/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFinder {
    private final World world;
    private final Block blockType;
    private final int metaValue;
    private final List<BlockPos> positions;

    public BlockFinder(World worldIn, Block type, int meta, int size) {
        this.world = worldIn;
        this.blockType = type;
        this.metaValue = meta;
        this.positions = new ArrayList<BlockPos>(size);
    }

    public Pair<BlockPos, BlockPos> cross(BlockPos initial) {
        List<BlockPos> allConnected = this.getAllConnectedBlocks(initial);
        int minX = initial.func_177958_n();
        int maxX = initial.func_177958_n();
        int minY = initial.func_177956_o();
        int maxY = initial.func_177956_o();
        int minZ = initial.func_177952_p();
        int maxZ = initial.func_177952_p();
        for (BlockPos pos : allConnected) {
            minX = Math.min(minX, pos.func_177958_n());
            minY = Math.min(minY, pos.func_177956_o());
            minZ = Math.min(minZ, pos.func_177952_p());
            maxX = Math.max(maxX, pos.func_177958_n());
            maxY = Math.max(maxY, pos.func_177956_o());
            maxZ = Math.max(maxZ, pos.func_177952_p());
        }
        return Pair.of((Object)new BlockPos(minX, minY, minZ), (Object)new BlockPos(maxX, maxY, maxZ));
    }

    public boolean box(Pair<BlockPos, BlockPos> corners) {
        for (int x = ((BlockPos)corners.getLeft()).func_177958_n(); x <= ((BlockPos)corners.getRight()).func_177958_n(); ++x) {
            for (int y = ((BlockPos)corners.getLeft()).func_177956_o(); y <= ((BlockPos)corners.getRight()).func_177956_o(); ++y) {
                for (int z = ((BlockPos)corners.getLeft()).func_177952_p(); z <= ((BlockPos)corners.getRight()).func_177952_p(); ++z) {
                    BlockPos temp = new BlockPos(x, y, z);
                    if (this.positions.contains(temp)) continue;
                    if (this.isTypeAt(temp)) {
                        this.positions.add(temp);
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void connect(BlockPos corner, BlockPos limit) {
        for (int i = 0; i < limit.func_177958_n(); ++i) {
            for (int j = 0; j < limit.func_177956_o(); ++j) {
                for (int k = 0; k < limit.func_177952_p(); ++k) {
                    BlockPos temp = corner.func_177982_a(i, j, k);
                    if (this.positions.contains(temp) || !this.isTypeAt(temp)) continue;
                    this.positions.add(temp);
                }
            }
        }
    }

    private boolean isTypeAt(int x, int y, int z) {
        return this.isTypeAt(new BlockPos(x, y, z));
    }

    private boolean isTypeAt(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_177230_c() == this.blockType && state.func_177230_c().func_176201_c(state) == this.metaValue;
    }

    public List<BlockPos> getPositions() {
        return this.positions;
    }

    public List<BlockPos> getAllConnectedBlocks(BlockPos initialPos) {
        int maxRadius = 20;
        ArrayList connectedBlocks = Lists.newArrayList();
        ArrayList searchedPositions = Lists.newArrayList();
        connectedBlocks.add(initialPos);
        searchedPositions.add(initialPos);
        this.getConnectedBlocks(maxRadius, connectedBlocks, searchedPositions, initialPos, initialPos);
        return connectedBlocks;
    }

    private void getConnectedBlocks(int maxRadius, List<BlockPos> connectedBlocks, List<BlockPos> searchedPositions, BlockPos currentPos, BlockPos initialPos) {
        if (currentPos.func_185332_f(initialPos.func_177958_n(), initialPos.func_177956_o(), initialPos.func_177952_p()) < (double)maxRadius) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = currentPos.func_177972_a(facing);
                IBlockState state = this.world.func_180495_p(offsetPos);
                if (searchedPositions.contains(offsetPos) || state.func_177230_c() != this.blockType || state.func_177230_c().func_176201_c(state) != this.metaValue) continue;
                connectedBlocks.add(offsetPos);
                searchedPositions.add(offsetPos);
                this.getConnectedBlocks(maxRadius, connectedBlocks, searchedPositions, offsetPos, initialPos);
            }
        }
    }
}

