/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;
import net.shadowmage.ancientwarfare.core.crafting.wrappers.NoRecipeWrapper;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class CraftingRecipeMemory {
    private final TileEntity tileEntity;
    private ICraftingRecipe recipe = NoRecipeWrapper.INSTANCE;
    public ItemStackHandler bookSlot = new ItemStackHandler(1){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return ItemResearchBook.getResearcherName(stack) != null ? super.insertItem(slot, stack, simulate) : stack;
        }

        protected void onContentsChanged(int slot) {
            CraftingRecipeMemory.this.tileEntity.func_70296_d();
        }
    };
    public InventoryCraftResult outputSlot = new InventoryCraftResult(){

        public void func_70299_a(int index, ItemStack stack) {
            super.func_70299_a(index, stack);
        }
    };
    public InventoryCrafting craftMatrix = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }, 3, 3){

        public void func_70296_d() {
            super.func_70296_d();
            CraftingRecipeMemory.this.tileEntity.func_70296_d();
            CraftingRecipeMemory.this.updateOutput(this);
        }
    };

    public List<ItemStack> getCraftingStacks() {
        NonNullList ret = NonNullList.func_191196_a();
        for (int slot = 0; slot < this.craftMatrix.func_70302_i_(); ++slot) {
            ret.add(this.craftMatrix.func_70301_a(slot));
        }
        return ret;
    }

    public CraftingRecipeMemory(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void dropInventory() {
        InventoryTools.dropItemsInWorld(this.tileEntity.func_145831_w(), (IItemHandler)this.bookSlot, this.tileEntity.func_174877_v());
        InventoryTools.dropItemsInWorld(this.tileEntity.func_145831_w(), (IInventory)this.craftMatrix, this.tileEntity.func_174877_v());
    }

    @Nullable
    public String getCrafterName() {
        return ItemResearchBook.getResearcherName(this.bookSlot.getStackInSlot(0));
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.bookSlot.deserializeNBT(tag.func_74775_l("bookSlot"));
        InventoryTools.readInventoryFromNBT((IInventory)this.outputSlot, tag.func_74775_l("outputSlot"));
        InventoryTools.readInventoryFromNBT((IInventory)this.craftMatrix, tag.func_74775_l("craftMatrix"));
        this.recipe = AWCraftingManager.getRecipe(RecipeResourceLocation.deserialize(tag.func_74779_i("recipe")));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("bookSlot", (NBTBase)this.bookSlot.serializeNBT());
        tag.func_74782_a("outputSlot", (NBTBase)InventoryTools.writeInventoryToNBT((IInventory)this.outputSlot, new NBTTagCompound()));
        tag.func_74782_a("craftMatrix", (NBTBase)InventoryTools.writeInventoryToNBT((IInventory)this.craftMatrix, new NBTTagCompound()));
        tag.func_74778_a("recipe", this.recipe.getRegistryName().toString());
        return tag;
    }

    public void setRecipe(ICraftingRecipe recipe) {
        this.recipe = recipe;
        this.updateOutput(this.craftMatrix);
    }

    private void updateOutput(InventoryCrafting craftingMatrix) {
        this.outputSlot.func_70299_a(0, this.recipe.getCraftingResult(craftingMatrix));
    }

    public ICraftingRecipe getRecipe() {
        return this.recipe;
    }

    public ItemStack getCraftingResult(InventoryCrafting invCrafting) {
        return this.recipe.getCraftingResult(invCrafting);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting invCrafting) {
        return this.recipe.getRemainingItems(invCrafting);
    }
}

