/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.research;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StringUtils;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.datafixes.ResearchEntryIdNameFixer;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.util.StreamUtils;

public class ResearchData
extends WorldSavedData {
    private HashMap<String, ResearchEntry> playerResearchEntries = new HashMap();

    public ResearchData(String par1Str) {
        super(par1Str);
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (!this.playerResearchEntries.containsKey(player.func_70005_c_())) {
            this.playerResearchEntries.put(player.func_70005_c_(), new ResearchEntry());
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.playerResearchEntries.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            ResearchEntry entry = new ResearchEntry();
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            String name = entryTag.func_74779_i("playerName");
            entry.readFromNBT(entryTag);
            this.playerResearchEntries.put(name, entry);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (String name : this.playerResearchEntries.keySet()) {
            ResearchEntry entry = this.playerResearchEntries.get(name);
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("playerName", name);
            entry.writeToNBT(entryTag);
            entryList.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    public void removeResearchFrom(String playerName, String research) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).removeResearch(research);
            this.func_76185_a();
        }
    }

    public void clearResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).clearResearch();
            this.func_76185_a();
        }
    }

    public void fillResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).fillResearch();
            this.func_76185_a();
        }
    }

    public Set<String> getResearchableGoals(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            ResearchEntry entry = this.playerResearchEntries.get(playerName);
            return ResearchData.getResearchableGoalsFor(entry);
        }
        return Collections.emptySet();
    }

    private static Set<String> getResearchableGoalsFor(ResearchEntry researchEntry) {
        HashSet<String> totalKnowledge = new HashSet<String>();
        totalKnowledge.addAll(researchEntry.getCompletedResearch());
        totalKnowledge.addAll(researchEntry.getQueuedResearch());
        Optional<String> inProgress = researchEntry.getCurrentResearch();
        inProgress.ifPresent(totalKnowledge::add);
        HashSet<String> researchableGoals = new HashSet<String>();
        for (ResearchGoal goal : ResearchRegistry.getAllResearchGoals()) {
            if (totalKnowledge.contains(goal.getName()) || !goal.canResearch(totalKnowledge)) continue;
            researchableGoals.add(goal.getName());
        }
        return researchableGoals;
    }

    public Set<String> getResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getCompletedResearch();
        }
        return Collections.emptySet();
    }

    public void addResearchTo(String playerName, String research) {
        if (!this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.put(playerName, new ResearchEntry());
        }
        this.playerResearchEntries.get(playerName).addResearch(research);
        this.func_76185_a();
    }

    public boolean hasPlayerCompletedResearch(String playerName, String research) {
        return this.playerResearchEntries.containsKey(playerName) && this.playerResearchEntries.get(playerName).knowsResearch(research);
    }

    public Optional<String> getInProgressResearch(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getCurrentResearch();
        }
        return Optional.empty();
    }

    public int getResearchProgress(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getResearchProgress();
        }
        return 0;
    }

    public void startResearch(String playerName, String goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).startResearch(goal);
            this.func_76185_a();
        }
    }

    public void finishResearch(String playerName, String goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).finishResearch(goal);
            this.func_76185_a();
        }
    }

    public void setCurrentResearchProgress(String playerName, int progress) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).setResearchProgress(progress);
            this.func_76185_a();
        }
    }

    public void addQueuedResearch(String playerName, String goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).addQueuedResearch(goal);
            this.func_76185_a();
        }
    }

    public void removeQueuedResearch(String playerName, String goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).removeQueuedResearch(goal);
            this.func_76185_a();
        }
    }

    public List<String> getQueuedResearch(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getResearchQueue();
        }
        return Collections.emptyList();
    }

    public boolean addProgress(String playerName, int amount) {
        boolean ret = false;
        if (this.playerResearchEntries.containsKey(playerName)) {
            ret = this.playerResearchEntries.get(playerName).addProgress(amount);
            this.func_76185_a();
        }
        return ret;
    }

    public boolean hasResearchStarted(String playerName) {
        return this.playerResearchEntries.containsKey(playerName) && this.playerResearchEntries.get(playerName).hasResearchStarted();
    }

    public static final class ResearchEntry {
        private String currentResearch = null;
        private int currentProgress = -1;
        private Set<String> completedResearch = new HashSet<String>();
        private List<String> queuedResearch = new ArrayList<String>();

        private boolean knowsResearch(String researchName) {
            return this.getCompletedResearch().contains(researchName);
        }

        public Optional<String> getCurrentResearch() {
            return Optional.ofNullable(this.currentResearch);
        }

        private void resetCurrentResearch() {
            this.currentResearch = null;
        }

        public void setCurrentResearch(String currentResearch) {
            if (StringUtils.func_151246_b((String)currentResearch)) {
                return;
            }
            this.currentResearch = currentResearch;
        }

        public boolean addProgress(int amount) {
            Optional<String> curResearch = this.getCurrentResearch();
            if (curResearch.isPresent()) {
                this.currentProgress += amount;
                if (this.currentProgress >= ResearchRegistry.getResearch(curResearch.get()).getTotalResearchTime()) {
                    this.finishResearch(curResearch.get());
                }
                return true;
            }
            return false;
        }

        public void finishResearch(String researchName) {
            if (this.getCurrentResearch().map(r -> r.equals(researchName)).orElse(false).booleanValue()) {
                this.getCompletedResearch().add(researchName);
                this.currentProgress = -1;
                this.resetCurrentResearch();
            }
        }

        public void startResearch(String goal) {
            if (this.getCurrentResearch().isPresent() || !this.queuedResearch.contains(goal)) {
                return;
            }
            this.queuedResearch.remove(goal);
            this.setCurrentResearch(goal);
            this.currentProgress = 0;
        }

        public boolean hasResearchStarted() {
            return this.currentProgress >= 0 && this.getCurrentResearch().isPresent();
        }

        private void setResearchProgress(int progress) {
            this.currentProgress = progress;
        }

        private int getResearchProgress() {
            return this.currentProgress;
        }

        private void addResearch(String researchName) {
            this.getCompletedResearch().add(researchName);
            if (this.queuedResearch.contains(researchName)) {
                this.queuedResearch.remove(researchName);
            }
            if (this.getCurrentResearch().map(r -> r.equals(researchName)).orElse(false).booleanValue()) {
                this.resetCurrentResearch();
                this.currentProgress = -1;
            }
        }

        private void removeResearch(String researchName) {
            this.getCompletedResearch().remove(researchName);
        }

        private void clearResearch() {
            this.getCompletedResearch().clear();
            this.currentProgress = -1;
            this.resetCurrentResearch();
            this.queuedResearch.clear();
        }

        private void fillResearch() {
            this.getCompletedResearch().clear();
            this.currentProgress = -1;
            this.resetCurrentResearch();
            this.queuedResearch.clear();
            for (ResearchGoal g : ResearchRegistry.getAllResearchGoals()) {
                this.getCompletedResearch().add(g.getName());
            }
        }

        private void addQueuedResearch(String researchName) {
            if (!this.queuedResearch.contains(researchName)) {
                this.queuedResearch.add(researchName);
            }
        }

        private List<String> getResearchQueue() {
            return this.queuedResearch;
        }

        private void writeToNBT(NBTTagCompound tag) {
            if (this.currentResearch != null) {
                tag.func_74778_a("currentResearch", this.currentResearch);
            }
            tag.func_74768_a("currentProgress", this.currentProgress);
            tag.func_74782_a("completedResearch", (NBTBase)this.getCompletedResearch().stream().map(NBTTagString::new).collect(StreamUtils.toNBTTagList));
            tag.func_74782_a("queuedResearch", (NBTBase)this.queuedResearch.stream().map(NBTTagString::new).collect(StreamUtils.toNBTTagList));
        }

        private void readFromNBT(NBTTagCompound tag) {
            NBTTagCompound fixedTag = ResearchEntryIdNameFixer.fix(tag);
            this.removeInvalidEntries(fixedTag);
            if (fixedTag.func_74764_b("currentResearch")) {
                this.currentResearch = fixedTag.func_74779_i("currentResearch");
            }
            this.currentProgress = fixedTag.func_74762_e("currentProgress");
            fixedTag.func_150295_c("completedResearch", 8).forEach(t -> this.getCompletedResearch().add(((NBTTagString)t).func_150285_a_()));
            fixedTag.func_150295_c("queuedResearch", 8).forEach(t -> this.queuedResearch.add(((NBTTagString)t).func_150285_a_()));
        }

        private void removeInvalidEntries(NBTTagCompound tag) {
            if (tag.func_74764_b("currentResearch") && !ResearchRegistry.researchExists(tag.func_74779_i("currentResearch"))) {
                tag.func_82580_o("currentResearch");
            }
            this.removeInvalidEntriesFromList(tag, "completedResearch");
            this.removeInvalidEntriesFromList(tag, "queuedResearch");
        }

        private void removeInvalidEntriesFromList(NBTTagCompound tag, String listName) {
            NBTTagList researchList = tag.func_150295_c(listName, 8);
            Iterator it = researchList.iterator();
            while (it.hasNext()) {
                String name = ((NBTTagString)it.next()).func_150285_a_();
                if (ResearchRegistry.researchExists(name)) continue;
                it.remove();
            }
            tag.func_74782_a(listName, (NBTBase)researchList);
        }

        private void removeQueuedResearch(String goal) {
            String exam;
            if (!this.queuedResearch.contains(goal)) {
                return;
            }
            ArrayList<String> goalsToValidate = new ArrayList<String>();
            Iterator<String> it = this.queuedResearch.iterator();
            boolean found = false;
            while (it.hasNext() && (exam = it.next()) != null) {
                if (found) {
                    goalsToValidate.add(exam);
                    it.remove();
                    continue;
                }
                if (!exam.equals(goal)) continue;
                found = true;
                it.remove();
            }
            HashSet<String> totalResearch = new HashSet<String>();
            totalResearch.addAll(this.getCompletedResearch());
            totalResearch.addAll(this.queuedResearch);
            Optional<String> currentResearch = this.getCurrentResearch();
            currentResearch.ifPresent(totalResearch::add);
            for (String g1 : goalsToValidate) {
                ResearchGoal g = ResearchRegistry.getResearch(g1);
                if (g == null || !g.canResearch(totalResearch)) continue;
                totalResearch.add(g1);
                this.queuedResearch.add(g1);
            }
        }

        public Set<String> getCompletedResearch() {
            return this.completedResearch;
        }

        public List<String> getQueuedResearch() {
            return this.queuedResearch;
        }
    }
}

