/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.core.render.BaseBakery;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;

public abstract class RotatableBlockRenderer
extends BaseBakery {
    protected RotatableBlockRenderer(String modelPath) {
        super(modelPath);
    }

    @Override
    protected Collection<CCModel> applyModelTransforms(Collection<CCModel> modelGroups, EnumFacing face, IExtendedBlockState state) {
        HashSet transformedGroups = Sets.newHashSet();
        for (CCModel group : modelGroups) {
            transformedGroups.add(this.rotateFacing(group.copy(), this.getFacing(state)));
        }
        return transformedGroups;
    }

    protected EnumFacing getFacing(IExtendedBlockState state) {
        return (EnumFacing)state.getValue(CoreProperties.UNLISTED_HORIZONTAL_FACING);
    }

    protected Collection<CCModel> rotateFacing(Collection<CCModel> groups, EnumFacing frontFacing) {
        return groups.stream().map(e -> this.rotateFacing(e.copy(), frontFacing)).collect(Collectors.toSet());
    }

    protected CCModel rotateFacing(CCModel group, EnumFacing frontFacing) {
        double angle = 1.5707963267948966 * (double)(frontFacing.func_176740_k() == EnumFacing.Axis.Y ? frontFacing.func_96559_d() : -(frontFacing.func_176736_b() + 2 & 3));
        return group.apply(new Rotation(angle, frontFacing.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : 0.0, frontFacing.func_176740_k() != EnumFacing.Axis.Y ? 1.0 : 0.0, 0.0).at(Vector3.center));
    }
}

