/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.render;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakery.generation.ISimpleBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelState;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseBakery
implements ISimpleBlockBakery {
    protected Map<String, CCModel> groups;
    public TextureAtlasSprite sprite;
    protected IconTransformation iconTransform;
    private static final ModelProperties.PerspectiveProperties MODEL_PROPERTIES;

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess access, BlockPos pos) {
        return state;
    }

    protected BaseBakery(String modelPath) {
        this.groups = OBJParser.parseModels((ResourceLocation)new ResourceLocation("ancientwarfare", "models/block/" + modelPath), (int)7, (Transformation)this.getBaseTransformation());
        for (Map.Entry<String, CCModel> group : this.groups.entrySet()) {
            group.setValue(group.getValue().backfacedCopy().computeNormals());
        }
    }

    protected Transformation getBaseTransformation() {
        return new RedundantTransformation();
    }

    public void setSprite(TextureAtlasSprite textureAtlasSprite) {
        this.sprite = textureAtlasSprite;
        this.iconTransform = new IconTransformation(this.sprite);
    }

    @Nonnull
    public List<BakedQuad> bakeQuads(@Nullable EnumFacing face, IExtendedBlockState state) {
        if (face != null) {
            return Collections.emptyList();
        }
        BakingVertexBuffer buffer = BakingVertexBuffer.create();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((BufferBuilder)buffer);
        Collection<CCModel> transformedGroups = this.applyModelTransforms(this.groups.values(), face, state);
        this.renderBlockModels(transformedGroups, ccrs, face, state);
        buffer.func_178977_d();
        return buffer.bake();
    }

    protected Collection<CCModel> applyModelTransforms(Collection<CCModel> modelGroups, EnumFacing face, IExtendedBlockState state) {
        return modelGroups;
    }

    protected void renderBlockModels(Collection<CCModel> modelGroups, CCRenderState ccrs, EnumFacing face, IExtendedBlockState state) {
        this.renderAllModels(modelGroups, ccrs, state);
    }

    private void renderAllModels(Collection<CCModel> modelGroups, CCRenderState ccrs, IExtendedBlockState state) {
        for (CCModel group : modelGroups) {
            group.render(ccrs, new IVertexOperation[]{this.getIconTransform(state)});
        }
    }

    private void renderAllModels(CCRenderState ccrs, ItemStack stack) {
        for (CCModel group : this.groups.values()) {
            group.render(ccrs, new IVertexOperation[]{this.getIconTransform(stack)});
        }
    }

    protected IconTransformation getIconTransform(IExtendedBlockState state) {
        return this.iconTransform;
    }

    protected IconTransformation getIconTransform(ItemStack stack) {
        return this.iconTransform;
    }

    protected void renderItemModels(CCRenderState ccrs, ItemStack stack) {
        this.renderAllModels(ccrs, stack);
    }

    @Nonnull
    public List<BakedQuad> bakeItemQuads(@Nullable EnumFacing face, ItemStack stack) {
        BakingVertexBuffer buffer = BakingVertexBuffer.create();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((BufferBuilder)buffer);
        this.renderItemModels(ccrs, stack);
        buffer.func_178977_d();
        return buffer.bake();
    }

    public ModelProperties.PerspectiveProperties getModelProperties(ItemStack stack) {
        return MODEL_PROPERTIES;
    }

    static {
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)2.5f, (float)0.0f, (float)75.0f, (float)225.0f, (float)0.0f, (float)0.375f);
        ImmutableMap.Builder defaultBlockBuilder = ImmutableMap.builder();
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)30.0f, (float)225.0f, (float)0.0f, (float)0.625f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.create((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)135.0f, (float)0.0f, (float)0.4f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)135.0f, (float)0.0f, (float)0.4f));
        MODEL_PROPERTIES = new ModelProperties.PerspectiveProperties((IModelState)new CCModelState((Map)defaultBlockBuilder.build()), true, true);
    }
}

