/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.manual.ManualContentRegistry;
import net.shadowmage.ancientwarfare.core.proxy.ClientProxyBase;
import net.shadowmage.ancientwarfare.core.registry.RegistryLoader;
import net.shadowmage.ancientwarfare.core.render.EngineeringStationRenderer;
import net.shadowmage.ancientwarfare.core.render.ResearchStationRenderer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ClientProxyBase {
    private static FontRenderer unicodeFontRenderer;

    public static FontRenderer getUnicodeFontRenderer() {
        return unicodeFontRenderer;
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (AWCoreStatics.DEBUG) {
            this.setDebugResolution();
        }
    }

    @Override
    public void init() {
        InputHandler.initKeyBindings();
        RegistryLoader.registerParser(new ManualContentRegistry.ManualContentParser());
    }

    private void setDebugResolution() {
        DisplayMode mode = new DisplayMode(512, 288);
        try {
            Display.setDisplayMode((DisplayMode)mode);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        Minecraft mc = Minecraft.func_71410_x();
        unicodeFontRenderer = new FontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.func_110434_K(), true);
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre evt) {
        EngineeringStationRenderer.INSTANCE.setSprite(evt.getMap().func_174942_a(new ResourceLocation("ancientwarfare:model/core/tile_engineering_station")));
        ResearchStationRenderer.INSTANCE.setSprite(evt.getMap().func_174942_a(new ResourceLocation("ancientwarfare:model/core/tile_research_station")));
    }
}

