/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.manual;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.manual.HeadingElement;
import net.shadowmage.ancientwarfare.core.manual.IContentElement;
import net.shadowmage.ancientwarfare.core.manual.ImageElement;
import net.shadowmage.ancientwarfare.core.manual.ItemElement;
import net.shadowmage.ancientwarfare.core.manual.TableOfContentsElement;
import net.shadowmage.ancientwarfare.core.manual.TextElement;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;

@SideOnly(value=Side.CLIENT)
public class ManualContentRegistry {
    private static Map<String, List<IContentElement>> englishCategoryContents = new HashMap<String, List<IContentElement>>();
    private static Map<String, List<IContentElement>> categoryContents = new HashMap<String, List<IContentElement>>();

    private ManualContentRegistry() {
    }

    public static List<IContentElement> getCategoryContent(String category) {
        if (categoryContents.containsKey(category)) {
            return categoryContents.get(category);
        }
        if (englishCategoryContents.containsKey(category)) {
            return englishCategoryContents.get(category);
        }
        return Collections.emptyList();
    }

    public static void clearContents() {
        englishCategoryContents.clear();
        categoryContents.clear();
    }

    public static class ManualContentParser
    implements IRegistryDataParser {
        private static final IContentElement EMPTY_ELEMENT = new IContentElement(){};

        @Override
        public String getName() {
            return "manual_content";
        }

        @Override
        public void parse(JsonObject json) {
            String lang = JsonUtils.func_151200_h((JsonObject)json, (String)"lang").toLowerCase();
            String currentLang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            if (!lang.equals("en_us") && !lang.equals(currentLang)) {
                return;
            }
            String category = JsonUtils.func_151200_h((JsonObject)json, (String)"category");
            ArrayList<IContentElement> contents = new ArrayList<IContentElement>();
            if (lang.equals("en_us") && !currentLang.equals(lang)) {
                englishCategoryContents.put(category, contents);
            } else {
                categoryContents.put(category, contents);
            }
            JsonArray elements = JsonUtils.func_151214_t((JsonObject)json, (String)"content");
            for (JsonElement el : elements) {
                JsonObject elementJson = JsonUtils.func_151210_l((JsonElement)el, (String)"");
                contents.add(this.parseElement(elementJson));
            }
        }

        private IContentElement parseElement(JsonObject elementJson) {
            String contentType;
            switch (contentType = JsonUtils.func_151200_h((JsonObject)elementJson, (String)"content_type")) {
                case "text": {
                    return TextElement.parse(elementJson);
                }
                case "heading": {
                    return HeadingElement.parse(elementJson);
                }
                case "toc_list": {
                    return TableOfContentsElement.parse(elementJson);
                }
                case "image": {
                    return ImageElement.parse(elementJson);
                }
                case "item": {
                    return ItemElement.parse(elementJson);
                }
            }
            return EMPTY_ELEMENT;
        }
    }
}

