/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.item.ItemBaseCore;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;

public class ItemResearchNotes
extends ItemBaseCore {
    private static final String RESEARCH_NAME_TAG = "researchName";
    private NonNullList<ItemStack> displayCache = null;

    public ItemResearchNotes() {
        super("research_note");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        String researchName = "corrupt_item";
        boolean known = false;
        if (tag != null && tag.func_74764_b(RESEARCH_NAME_TAG)) {
            String name = tag.func_74779_i(RESEARCH_NAME_TAG);
            if (ResearchRegistry.researchExists(name) && Minecraft.func_71410_x().field_71439_g != null && world != null) {
                researchName = net.minecraft.client.resources.I18n.func_135052_a((String)ResearchGoal.getUnlocalizedName(name), (Object[])new Object[0]);
                known = ResearchTracker.INSTANCE.hasPlayerCompleted(world, Minecraft.func_71410_x().field_71439_g.func_70005_c_(), name);
            } else {
                researchName = "missing_goal_for_id_" + researchName;
            }
        }
        tooltip.add(researchName);
        if (known) {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"guistrings.research.known_research", (Object[])new Object[0]));
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"guistrings.research.click_to_add_progress", (Object[])new Object[0]));
        } else {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"guistrings.research.unknown_research", (Object[])new Object[0]));
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"guistrings.research.click_to_learn", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (this.displayCache != null && !this.displayCache.isEmpty()) {
            items.addAll(this.displayCache);
            return;
        }
        this.displayCache = NonNullList.func_191196_a();
        for (ResearchGoal goal : ResearchRegistry.getAllResearchGoals().stream().sorted(Comparator.comparing(ResearchGoal::getName)).collect(Collectors.toCollection(LinkedHashSet::new))) {
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77983_a(RESEARCH_NAME_TAG, (NBTBase)new NBTTagString(goal.getName()));
            this.displayCache.add((Object)stack);
            items.add((Object)stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        String name;
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = stack.func_77978_p();
        if (!world.field_72995_K && tag != null && tag.func_74764_b(RESEARCH_NAME_TAG) && ResearchRegistry.researchExists(name = tag.func_74779_i(RESEARCH_NAME_TAG))) {
            boolean known = ResearchTracker.INSTANCE.hasPlayerCompleted(player.field_70170_p, player.func_70005_c_(), name);
            if (!known) {
                if (ResearchTracker.INSTANCE.addResearchFromNotes(player.field_70170_p, player.func_70005_c_(), name)) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.research.learned_from_item", new Object[]{I18n.func_74838_a((String)name)}));
                    stack.func_190918_g(1);
                }
            } else if (ResearchTracker.INSTANCE.addProgressFromNotes(player.field_70170_p, player.func_70005_c_(), name)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.research.added_progress", new Object[]{I18n.func_74838_a((String)name)}));
                stack.func_190918_g(1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

