/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiInfoTool;
import net.shadowmage.ancientwarfare.core.item.ItemBaseCore;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.ItemTools;

public class ItemInfoTool
extends ItemBaseCore {
    public ItemInfoTool() {
        super("info_tool");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getMode(stack).toString() + " mode");
    }

    private void printSimpleMessage(EntityPlayer player, IBlockState state) {
        player.func_145747_a((ITextComponent)new TextComponentString("Block name: " + state.func_177230_c().getRegistryName().toString()));
        if (!state.func_177228_b().isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Properties:"));
            for (Map.Entry prop : state.func_177228_b().entrySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString(((IProperty)prop.getKey()).func_177701_a() + " : " + ((Comparable)prop.getValue()).toString()));
            }
        }
    }

    private void printJSON(EntityPlayer player, IBlockState state) {
        String json = BlockTools.serializeToJson(state).toString();
        StringSelection stringSelection = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        player.func_145747_a((ITextComponent)new TextComponentString(json));
        player.func_145747_a((ITextComponent)new TextComponentString("Copied to clipboard"));
    }

    public void printItemInfo(EntityPlayer player, ItemStack infoTool, ItemStack stack) {
        if (this.getMode(infoTool) == Mode.INFO) {
            this.printSimpleMessage(player, stack);
        } else {
            this.printJSON(player, stack);
        }
    }

    private void printSimpleMessage(EntityPlayer player, ItemStack stack) {
        player.func_145747_a((ITextComponent)new TextComponentString("Item name: " + stack.func_77973_b().getRegistryName().toString()));
        player.func_145747_a((ITextComponent)new TextComponentString("Meta: " + stack.func_77960_j()));
        if (stack.func_77942_o()) {
            player.func_145747_a((ITextComponent)new TextComponentString("NBT: " + stack.func_77978_p().toString()));
        }
    }

    private void printJSON(EntityPlayer player, ItemStack stack) {
        String json = ItemTools.serializeToJson(stack).toString();
        StringSelection stringSelection = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        player.func_145747_a((ITextComponent)new TextComponentString(json));
        player.func_145747_a((ITextComponent)new TextComponentString("Copied to clipboard"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult hit = this.func_77621_a(world, player, true);
        if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = world.func_180495_p(hit.func_178782_a());
            if (this.getMode(player.func_184586_b(hand)) == Mode.INFO) {
                this.printSimpleMessage(player, state);
            } else {
                this.printJSON(player, state);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.cycleMode(player.func_184586_b(hand)));
        }
        NetworkHandler.INSTANCE.openGui(player, 57);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private ItemStack cycleMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("mode", this.getMode(stack) == Mode.INFO ? "json" : "info");
        return stack;
    }

    private Mode getMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("mode").equals("json") ? Mode.JSON : Mode.INFO;
        }
        return Mode.INFO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(57, GuiInfoTool.class);
    }

    static enum Mode {
        INFO,
        JSON;

    }
}

