/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.item.ItemBlockBase;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class ItemBlockRotatableMetaTile
extends ItemBlockBase {
    private BlockRotationHandler.IRotatableBlock rotatable;

    public ItemBlockRotatableMetaTile(Block block) {
        super(block);
        if (!(block instanceof BlockRotationHandler.IRotatableBlock)) {
            throw new IllegalArgumentException("Must be a rotatable block!!");
        }
        this.rotatable = (BlockRotationHandler.IRotatableBlock)block;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean val = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (val) {
            TileEntity te = player.field_70170_p.func_175625_s(pos);
            if (te instanceof IOwnable) {
                ((IOwnable)te).setOwner(player);
            }
            if (te instanceof BlockRotationHandler.IRotatableTile) {
                ((BlockRotationHandler.IRotatableTile)te).setPrimaryFacing(BlockRotationHandler.getFaceForPlacement((EntityLivingBase)player, this.rotatable, side));
            }
            BlockTools.notifyBlockUpdate(world, pos);
        }
        return val;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77952_i();
    }
}

