/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.init.AWCoreItems;
import net.shadowmage.ancientwarfare.core.item.ItemBackpack;

public class ItemHandlerBackpack
implements IItemHandlerModifiable {
    private static final String BACKPACK_ITEMS_TAG = "backpackItems";
    private final ItemStackHandler backpackInventory;
    private final ItemStack backpackStack;

    public ItemHandlerBackpack(ItemStack backpackStack) {
        this.backpackInventory = this.getHandler(backpackStack);
        this.backpackStack = backpackStack;
    }

    public int getSlots() {
        return this.backpackInventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.backpackInventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack ret = stack;
        if (stack.func_77973_b() != AWCoreItems.BACKPACK && (ret = this.backpackInventory.insertItem(slot, stack, simulate)).func_190916_E() < stack.func_190916_E()) {
            this.saveToStack(this.backpackInventory);
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack ret = this.backpackInventory.extractItem(slot, amount, simulate);
        if (!ret.func_190926_b()) {
            this.saveToStack(this.backpackInventory);
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.backpackInventory.getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.backpackInventory.setStackInSlot(slot, stack);
        this.saveToStack(this.backpackInventory);
    }

    private ItemStackHandler getHandler(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBackpack) {
            ItemStackHandler handler = new ItemStackHandler((stack.func_77952_i() + 1) * 9);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(BACKPACK_ITEMS_TAG)) {
                handler.deserializeNBT(stack.func_77978_p().func_74775_l(BACKPACK_ITEMS_TAG));
            }
            return handler;
        }
        return new ItemStackHandler();
    }

    private void saveToStack(ItemStackHandler handler) {
        NBTTagCompound invTag = handler.serializeNBT();
        this.backpackStack.func_77983_a(BACKPACK_ITEMS_TAG, (NBTBase)invTag);
    }
}

