/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.interfaces;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public final class ITorque {
    private ITorque() {
    }

    public static class SidedTorqueCell
    extends TorqueCell {
        EnumFacing dir;
        ITorqueTile owner;

        public SidedTorqueCell(double in, double out, double max, double eff, EnumFacing dir, ITorqueTile owner) {
            super(in, out, max, eff);
            this.dir = dir;
            this.owner = owner;
        }

        @Override
        public double getMaxTickInput() {
            return this.owner.canInputTorque(this.dir) ? super.getMaxTickInput() : 0.0;
        }

        @Override
        public double getMaxTickOutput() {
            return this.owner.canOutputTorque(this.dir) ? super.getMaxTickOutput() : 0.0;
        }

        @Override
        public double addEnergy(double in) {
            return this.owner.canInputTorque(this.dir) ? super.addEnergy(in) : 0.0;
        }

        @Override
        public double drainEnergy(double request) {
            return this.owner.canOutputTorque(this.dir) ? super.drainEnergy(request) : 0.0;
        }
    }

    public static class TorqueCell {
        double maxInput;
        double maxOutput;
        double maxEnergy;
        double efficiency;
        protected double energy;

        public TorqueCell(double in, double out, double max, double eff) {
            this.maxInput = in;
            this.maxOutput = out;
            this.maxEnergy = max;
            this.efficiency = eff;
        }

        public double getEfficiency() {
            return this.efficiency;
        }

        public double getEnergy() {
            return this.energy;
        }

        public double getMaxEnergy() {
            return this.maxEnergy;
        }

        public void setEnergy(double in) {
            this.energy = Math.max(0.0, Math.min(in, this.maxEnergy));
        }

        public double addEnergy(double in) {
            if (Double.isNaN(in)) {
                throw new RuntimeException("Requested input may not be NAN");
            }
            in = Math.min(this.getMaxTickInput(), in);
            this.energy += in;
            return in;
        }

        public double drainEnergy(double request) {
            if (Double.isNaN(request)) {
                throw new RuntimeException("Requested drain may not be NAN");
            }
            request = Math.min(this.getMaxTickOutput(), request);
            this.energy -= request;
            return request;
        }

        public double getMaxInput() {
            return this.maxInput;
        }

        public double getMaxOutput() {
            return this.maxOutput;
        }

        public double getMaxTickInput() {
            return Math.min(this.maxInput, this.getMaxEnergy() - this.getEnergy());
        }

        public double getMaxTickOutput() {
            return Math.min(this.maxOutput, this.getEnergy());
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("energy", this.energy);
            return tag;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.energy = tag.func_74769_h("energy");
        }

        public double getPercentFull() {
            return this.maxEnergy > 0.0 ? this.energy / this.maxEnergy : 0.0;
        }
    }

    public static interface ITorqueTile {
        public double getMaxTorque(@Nullable EnumFacing var1);

        public double getTorqueStored(@Nullable EnumFacing var1);

        public double addTorque(@Nullable EnumFacing var1, double var2);

        public double drainTorque(EnumFacing var1, double var2);

        public double getMaxTorqueOutput(EnumFacing var1);

        public double getMaxTorqueInput(@Nullable EnumFacing var1);

        public boolean canOutputTorque(EnumFacing var1);

        public boolean canInputTorque(EnumFacing var1);

        public boolean useOutputRotation(@Nullable EnumFacing var1);

        public float getClientOutputRotation(EnumFacing var1, float var2);
    }
}

