/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ancientwarfare")
public class AWCoreLoot {
    private static final List<String> CHEST_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"desert_pyramid", (Object)"igloo_chest", (Object)"jungle_temple", (Object)"simple_dungeon", (Object)"stronghold_corridor", (Object)"village_blacksmith");
    private static final String CHESTS_PREFIX = "minecraft:chests/";

    public static void init() {
        for (String s : CHEST_TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientwarfare", "inject/chests/" + s));
        }
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String name = evt.getName().toString();
        if (name.startsWith(CHESTS_PREFIX) && CHEST_TABLES.contains(name.substring(CHESTS_PREFIX.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(AWCoreLoot.getInjectPool(file));
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{AWCoreLoot.getInjectEntry(entryName)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "ancientwarfare_inject_pool");
    }

    private static LootEntryTable getInjectEntry(String name) {
        return new LootEntryTable(new ResourceLocation("ancientwarfare", "inject/" + name), 1, 0, new LootCondition[0], "ancientwarfare_inject_entry");
    }
}

