/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.research;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.shadowmage.ancientwarfare.core.block.Direction;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.container.ContainerResearchBook;
import net.shadowmage.ancientwarfare.core.container.ContainerResearchStation;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiResearchBook;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.ProgressBar;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.gui.research.GuiResearchStationSelection;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.tile.TileResearchStation;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import org.lwjgl.input.Mouse;

public class GuiResearchStation
extends GuiContainerBase<ContainerResearchStation> {
    private Label researcherLabel;
    private Label researchGoalLabel;
    private ProgressBar bar;
    private Checkbox useAdjacentInventory;
    private Button info;
    private Button invDir;
    private Button invSide;
    private ItemSlot[] layoutSlots = new ItemSlot[9];

    public GuiResearchStation(ContainerBase par1Container) {
        super(par1Container, 178, 240);
    }

    @Override
    public void initElements() {
        ResearchGoal g;
        String name = ((ContainerResearchStation)((Object)this.getContainer())).researcherName == null ? "guistrings.research.no_researcher" : ((ContainerResearchStation)((Object)this.getContainer())).researcherName;
        this.researcherLabel = new Label(8, 8, name);
        this.addGuiElement(this.researcherLabel);
        name = "guistrings.research.no_research";
        String researchName = ((ContainerResearchStation)((Object)this.getContainer())).currentGoal;
        if (!researchName.equals("") && (g = ResearchRegistry.getResearch(researchName)) != null) {
            name = g.getName();
        }
        this.researchGoalLabel = new Label(80, 44, name);
        this.addGuiElement(this.researchGoalLabel);
        this.addGuiElement(new Label(8, 44, I18n.func_135052_a((String)"guistrings.research.current_goal", (Object[])new Object[0]) + ":"));
        this.bar = new ProgressBar(70, 56, 100, 12);
        this.addGuiElement(this.bar);
        Button button = new Button(60, 24, 110, 12, "guistrings.research.research_queue"){

            @Override
            protected void onPressed() {
                ((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).removeSlots();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiResearchStationSelection(GuiResearchStation.this, Mouse.getX(), Mouse.getY()));
            }
        };
        this.addGuiElement(button);
        this.info = new Button(30, 24, 24, 12, "guistrings.research.info"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiResearchBook(new ContainerResearchBook(((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).player, 0, 0, 0)));
            }
        };
        this.addGuiElement(this.info);
        if (((ContainerResearchStation)((Object)this.getContainer())).researcherName == null) {
            this.info.setEnabled(false);
        }
        for (int i = 0; i < this.layoutSlots.length; ++i) {
            int x = i % 3 * 18 + 98;
            int y = i / 3 * 18 + 98;
            this.layoutSlots[i] = new ItemSlot(x, y, ItemStack.field_190927_a, this);
            this.addGuiElement(this.layoutSlots[i]);
        }
        this.addGuiElement(new Label(8, 57, "guistrings.research.progress"));
        this.addGuiElement(new Label(26, 86, "guistrings.research.input"));
        this.addGuiElement(new Label(98, 86, "guistrings.research.needed"));
        this.useAdjacentInventory = new Checkbox(8, 68, 16, 16, "guistrings.research.adj_inv"){

            @Override
            public void onToggled() {
                ((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).toggleUseAdjacentInventory();
                this.setChecked(((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).useAdjacentInventory);
            }
        };
        Tooltip tip = new Tooltip(50, 20);
        tip.addTooltipElement(new Label(0, 0, "guistrings.research.use_adjacent_inventory"));
        this.useAdjacentInventory.setTooltip(tip);
        this.addGuiElement(this.useAdjacentInventory);
        this.invDir = new Button(80, 68, 40, 16, Direction.getDirectionFor(((TileResearchStation)((ContainerResearchStation)((Object)this.getContainer())).tileEntity).inventoryDirection).getTranslationKey()){

            @Override
            protected void onPressed() {
                ((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).onDirPressed();
                GuiResearchStation.this.refreshGui();
            }
        };
        tip = new Tooltip(50, 20);
        tip.addTooltipElement(new Label(0, 0, "guistrings.research.invDir"));
        this.invDir.setTooltip(tip);
        this.addGuiElement(this.invDir);
        this.invSide = new Button(120, 68, 40, 16, Direction.getDirectionFor(((TileResearchStation)((ContainerResearchStation)((Object)this.getContainer())).tileEntity).inventorySide).getTranslationKey()){

            @Override
            protected void onPressed() {
                ((ContainerResearchStation)((Object)GuiResearchStation.this.getContainer())).onSidePressed();
                GuiResearchStation.this.refreshGui();
            }
        };
        tip = new Tooltip(50, 20);
        tip.addTooltipElement(new Label(0, 0, "guistrings.research.invSide"));
        this.invSide.setTooltip(tip);
        this.addGuiElement(this.invSide);
    }

    @Override
    public void setupElements() {
        String name = ((ContainerResearchStation)((Object)this.getContainer())).researcherName == null ? "guistrings.research.no_researcher" : ((ContainerResearchStation)((Object)this.getContainer())).researcherName;
        this.researcherLabel.setText(name);
        if (((ContainerResearchStation)((Object)this.getContainer())).researcherName == null) {
            this.cleanLayout();
            this.info.setEnabled(false);
        } else {
            this.info.setEnabled(true);
        }
        name = "guistrings.research.no_research";
        String researchName = ((ContainerResearchStation)((Object)this.getContainer())).currentGoal;
        float progress = 0.0f;
        if (!researchName.equals("")) {
            ResearchGoal g = ResearchRegistry.getResearch(researchName);
            if (g != null) {
                name = g.getUnlocalizedName();
                float total = g.getTotalResearchTime();
                float time = ((ContainerResearchStation)((Object)this.getContainer())).progress;
                if (total == 0.0f) {
                    total = time;
                }
                progress = time / total;
            }
            this.cleanLayout();
        } else {
            List<String> queue = ((ContainerResearchStation)((Object)this.getContainer())).queuedResearch;
            if (!queue.isEmpty()) {
                String g1 = queue.get(0);
                ResearchGoal g = ResearchRegistry.getResearch(g1);
                if (g != null) {
                    name = g.getUnlocalizedName();
                    NonNullList<ItemStack> resources = g.getResourcesForDisplay();
                    for (int i = 0; i < this.layoutSlots.length; ++i) {
                        if (i >= resources.size()) {
                            this.layoutSlots[i].setItem(ItemStack.field_190927_a);
                            continue;
                        }
                        ItemStack resource = (ItemStack)resources.get(i);
                        if (InventoryTools.doItemStacksMatchRelaxed(resource, this.layoutSlots[i].getStack())) continue;
                        this.layoutSlots[i].setItem(resource.func_77946_l());
                    }
                }
            } else {
                this.cleanLayout();
            }
        }
        this.bar.setProgress(progress);
        this.researchGoalLabel.setText(name);
        this.useAdjacentInventory.setChecked(((ContainerResearchStation)((Object)this.getContainer())).useAdjacentInventory);
        this.invDir.setText(Direction.getDirectionFor(((TileResearchStation)((ContainerResearchStation)((Object)this.getContainer())).tileEntity).inventoryDirection).getTranslationKey());
        this.invSide.setText(Direction.getDirectionFor(((TileResearchStation)((ContainerResearchStation)((Object)this.getContainer())).tileEntity).inventorySide).getTranslationKey());
    }

    private void cleanLayout() {
        for (ItemSlot layoutSlot : this.layoutSlots) {
            layoutSlot.setItem(ItemStack.field_190927_a);
        }
    }
}

