/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual;

import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.TextureData;
import net.shadowmage.ancientwarfare.core.gui.elements.Composite;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ImageButton;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;

public class Paging
extends Composite {
    private static final int TOP_PADDING = 4;
    private static final int SIDE_PADDING = 7;
    private final boolean leftPage;
    private PagingButton pagingButton;

    public Paging(final GuiManual gui, int topLeftX, int topLeftY, int width, int height, ResourceLocation manualTexture, boolean leftPage) {
        super(gui, topLeftX, topLeftY, width, height);
        this.leftPage = leftPage;
        if (leftPage) {
            this.pagingButton = new PagingButton(7, 10, manualTexture){

                @Override
                protected void onPressed(int mButton) {
                    gui.setCurrentPageIndex(Math.max(gui.getCurrentPageIndex() - 2, 0));
                    Paging.this.updateButtonVisibility();
                }
            };
            this.addGuiElement(this.pagingButton);
        } else {
            this.pagingButton = new PagingButton(width - 18 - 7, 0, manualTexture){

                @Override
                protected void onPressed(int mButton) {
                    gui.setCurrentPageIndex(Math.min(gui.getCurrentPageIndex() + 2, gui.getPageCount() - 1));
                    Paging.this.updateButtonVisibility();
                }
            };
            this.addGuiElement(this.pagingButton);
        }
        this.addGuiElement(new Label(width / 2, 4, Integer.toString(gui.getCurrentPageIndex() + (leftPage ? 1 : 2))).setColor(Color.GRAY.getRGB()).setRenderCentered());
        this.updateButtonVisibility();
    }

    @Override
    public GuiManual getGui() {
        return (GuiManual)super.getGui();
    }

    private void updateButtonVisibility() {
        this.pagingButton.setVisible(this.leftPage && this.getGui().getCurrentPageIndex() > 0 || !this.leftPage && this.getGui().getCurrentPageIndex() + 2 < this.getGui().getPageCount());
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        for (GuiElement element : this.elements) {
            element.render(mouseX, mouseY, partialTick);
        }
    }

    private abstract class PagingButton
    extends ImageButton {
        static final int BUTTON_WIDTH = 18;
        private static final int BUTTON_HEIGHT = 10;

        private PagingButton(int topLeftX, int textureV, ResourceLocation manualTexture) {
            super(topLeftX, 4, 18, 10, new TextureData(manualTexture, 512, 512, 412, textureV, 18, 10), Color.GRAY, Color.CYAN);
        }
    }
}

