/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.container.ContainerManual;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.TextureData;
import net.shadowmage.ancientwarfare.core.gui.elements.ImageButton;
import net.shadowmage.ancientwarfare.core.gui.manual.ElementWrapperFactory;
import net.shadowmage.ancientwarfare.core.gui.manual.Page;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;
import net.shadowmage.ancientwarfare.core.manual.IContentElement;
import net.shadowmage.ancientwarfare.core.manual.ManualContentRegistry;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class GuiManual
extends GuiContainerBase<ContainerManual> {
    private static final int BOOK_WIDTH = 412;
    private static final int PAGE_WIDTH = 206;
    private static final int BOOK_HEIGHT = 254;
    public static final int FOOTER_HEIGHT = 14;
    private static final ResourceLocation MANUAL_TEXTURE = new ResourceLocation("ancientwarfare", "textures/gui/manual.png");
    private static final int HORIZONTAL_PAGE_PADDING = 8;
    private static final int VERTICAL_PAGE_PADDING = 7;
    private static final String INITIAL_CATEGORY = "table_of_contents";
    private List<List<BaseElementWrapper>> pageElements;
    private int currentPageIndex = 0;
    private Page leftPage;
    private Page rightPage;
    private ImageButton backButton;
    private String currentCategory = "table_of_contents";
    private String previousCategory = "";

    public GuiManual(ContainerBase container) {
        super(container, 412, 254);
        this.loadCategory(this.currentCategory);
    }

    private void loadCategory(String category) {
        List<IContentElement> elements = ManualContentRegistry.getCategoryContent(category);
        int innerPageWidth = 198 - 2 * Page.getPadding();
        this.pageElements = ElementWrapperFactory.getPagedWrappedContent(this, elements, innerPageWidth, this.getInnerPageHeight());
    }

    private int getInnerPageHeight() {
        return 240 - 2 * Page.getPadding() - 14;
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MANUAL_TEXTURE);
        RenderTools.renderQuarteredTexture(512, 512, 0, 0, 412, 254, this.field_146294_l / 2 - this.field_146999_f / 2, this.field_146295_m / 2 - this.field_147000_g / 2, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void initElements() {
        int pageWidth = 198;
        int pageHeight = 240;
        this.leftPage = new Page(this, 8, 7, pageWidth, pageHeight, new TextureData(MANUAL_TEXTURE, 512, 512, 8, 261, pageWidth, pageHeight), true);
        this.addGuiElement(this.leftPage);
        this.rightPage = new Page(this, 206, 7, 198, 240, new TextureData(MANUAL_TEXTURE, 512, 512, 206, 261, pageWidth, pageHeight), false);
        this.addGuiElement(this.rightPage);
        this.refreshGui();
        this.backButton = new ImageButton(-8, 0, 14, 16, new TextureData(MANUAL_TEXTURE, 512, 512, 412, 41, 14, 16), Color.GRAY, Color.CYAN){

            @Override
            protected void onPressed(int mButton) {
                GuiManual.this.setCurrentCategory(GuiManual.this.previousCategory);
            }
        };
        this.addGuiElement(this.backButton);
    }

    private List<BaseElementWrapper> getPageElements(int pageNumber) {
        return this.pageElements.size() > pageNumber ? this.pageElements.get(pageNumber) : Collections.emptyList();
    }

    @Override
    public void setupElements() {
        this.leftPage.updateContentElements(this.getPageElements(this.getCurrentPageIndex()));
        this.rightPage.updateContentElements(this.getPageElements(this.getCurrentPageIndex() + 1));
        this.backButton.setVisible(!this.currentCategory.equals(INITIAL_CATEGORY));
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
        this.refreshGui();
    }

    public int getPageCount() {
        return this.pageElements.size();
    }

    public void setCurrentCategory(String category) {
        this.currentPageIndex = 0;
        this.previousCategory = this.currentCategory;
        this.currentCategory = category;
        this.loadCategory(category);
        this.refreshGui();
    }
}

