/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;

@SideOnly(value=Side.CLIENT)
public class Label
extends GuiElement {
    private String text;
    private boolean renderCentered = false;
    private int color = -1;
    private boolean renderShadow;

    public Label(int topLeftX, int topLeftY, String text) {
        super(topLeftX, topLeftY);
        this.setText(text);
    }

    public Label setRenderCentered() {
        this.renderCentered = true;
        return this;
    }

    public Label setColor(int color) {
        this.color = color;
        return this;
    }

    public Label setShadow(boolean renderShadow) {
        this.renderShadow = renderShadow;
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            if (this.renderCentered) {
                this.drawText(this.width / 2);
            } else {
                this.drawText(0);
            }
        }
    }

    private void drawText(int offset) {
        if (this.width < Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text)) {
            Minecraft.func_71410_x().field_71466_p.func_78279_b(this.text, this.renderX - offset, this.renderY, this.width, 0xDDDDDD);
        } else if (this.renderShadow) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.text, (float)(this.renderX - offset), (float)this.renderY, this.color);
        } else {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(this.text, this.renderX - offset, this.renderY, this.color);
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = I18n.func_135052_a((String)text, (Object[])new Object[0]);
        this.setTooltipIfFound(text);
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text);
        this.height = 8;
    }

    public String getText() {
        return this.text;
    }
}

