/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemSlot
extends GuiElement {
    private static final RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
    @Nonnull
    private ItemStack item = ItemStack.field_190927_a;
    protected ITooltipRenderer render;
    protected boolean highlightOnMouseOver = true;
    protected boolean renderItemQuantity = true;
    protected boolean renderSlotBackground = true;
    protected boolean renderLabel = false;

    public ItemSlot(int topLeftX, int topLeftY, @Nonnull ItemStack item, ITooltipRenderer render) {
        super(topLeftX - 1, topLeftY - 1, 18, 18);
        this.item = item;
        this.render = render;
        Listener listener = new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                    ItemSlot.this.onSlotClicked(stack, evt.mButton == 1);
                }
                return true;
            }
        };
        this.addNewListener(listener);
    }

    public void setRenderLabel(boolean val) {
        this.renderLabel = val;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemSlot setRenderTooltip(boolean val) {
        this.renderTooltip = val;
        return this;
    }

    public ItemSlot setRenderItemQuantity(boolean val) {
        this.renderItemQuantity = val;
        return this;
    }

    public ItemSlot setHighlightOnMouseOver(boolean val) {
        this.highlightOnMouseOver = val;
        return this;
    }

    public ItemSlot setRenderSlotBackground(boolean val) {
        this.renderSlotBackground = val;
        return this;
    }

    public ItemStack getStack() {
        return this.item;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.renderSlotBackground) {
                mc.field_71446_o.func_110577_a(widgetTexture1);
                RenderTools.renderQuarteredTexture(256, 256, 152, 120, 18, 18, this.renderX, this.renderY, this.width, this.height);
            }
            if (!this.item.func_190926_b()) {
                ItemSlot.itemRender.field_77023_b = 10.0f;
                FontRenderer font = this.item.func_77973_b().getFontRenderer(this.item);
                if (font == null) {
                    font = mc.field_71466_p;
                }
                GlStateManager.func_179091_B();
                RenderHelper.func_74520_c();
                itemRender.func_180450_b(this.item, this.renderX + 1, this.renderY + 1);
                if (this.renderItemQuantity && this.item.func_190916_E() > 1) {
                    itemRender.func_180453_a(font, this.item, this.renderX + 1, this.renderY + 1, "");
                    this.renderStackSize(this.renderX + 1, this.renderY + 1, this.item.func_190916_E(), font);
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                if (this.renderLabel) {
                    int x = this.renderX + 18;
                    int y = this.renderY + 3;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    font.func_175063_a(this.item.func_82833_r(), (float)x, (float)y, -1);
                }
            }
            if (this.isMouseOverElement(mouseX, mouseY)) {
                if (this.highlightOnMouseOver) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                    GlStateManager.func_187447_r((int)7);
                    GL11.glVertex2f((float)(this.renderX + 1), (float)(this.renderY + 1));
                    GL11.glVertex2f((float)(this.renderX + 1), (float)(this.renderY + 1 + (this.height - 2)));
                    GL11.glVertex2f((float)(this.renderX + 1 + (this.width - 2)), (float)(this.renderY + 1 + (this.height - 2)));
                    GL11.glVertex2d((double)(this.renderX + 1 + (this.width - 2)), (double)(this.renderY + 1));
                    GlStateManager.func_187437_J();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                }
                if (this.renderTooltip && this.render != null) {
                    if (this.tooltip != null) {
                        this.render.handleElementTooltipRender(this.tooltip, mouseX, mouseY);
                    } else if (!this.item.func_190926_b()) {
                        this.render.handleItemStackTooltipRender(this.item, mouseX, mouseY);
                    }
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderStackSize(int renderX, int renderY, int stackSize, FontRenderer fr) {
        GlStateManager.func_179094_E();
        float ox = renderX + 16;
        float oy = renderY + 8;
        GlStateManager.func_179109_b((float)(ox + 0.5f), (float)(oy + 0.5f), (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        String s1 = String.valueOf(stackSize);
        float w = fr.func_78256_a(s1);
        float scale = stackSize > 99 ? 0.5f : 1.0f;
        int oy1 = stackSize > 99 ? 6 : 0;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fr.func_175063_a(s1, (float)(-((int)w)), (float)oy1, 0xFFFFFF);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public void onSlotClicked(ItemStack stack, boolean rightClicked) {
    }
}

