/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.TextureData;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

public abstract class ImageButton
extends GuiElement {
    private final TextureData textureData;
    private final Color colorOutOfFocus;
    private final Color colorInFocus;
    private boolean pressed = false;

    public ImageButton(int topLeftX, int topLeftY, int width, int height, TextureData textureData, Color colorOutOfFocus, Color colorInFocus) {
        super(topLeftX, topLeftY, width, height);
        this.textureData = textureData;
        this.colorOutOfFocus = colorOutOfFocus;
        this.colorInFocus = colorInFocus;
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ImageButton.this.pressed && ImageButton.this.enabled && ImageButton.this.visible && ImageButton.this.isMouseOverElement(evt.mx, evt.my)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    ImageButton.this.onPressed(evt.mButton);
                }
                ImageButton.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ImageButton.this.enabled && ImageButton.this.visible && ImageButton.this.isMouseOverElement(evt.mx, evt.my)) {
                    ImageButton.this.pressed = true;
                }
                return true;
            }
        });
    }

    protected abstract void onPressed(int var1);

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureData.getTexture());
            Color color = this.isMouseOverElement(mouseX, mouseY) ? this.colorInFocus : this.colorOutOfFocus;
            GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
            RenderTools.renderQuarteredTexture(this.textureData.getTextureWidth(), this.textureData.getTextureHeight(), this.textureData.getTextureU(), this.textureData.getTextureV(), this.textureData.getPartWidth(), this.textureData.getPartHeight(), this.renderX, this.renderY, this.width, this.height);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

