/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class Checkbox
extends GuiElement {
    private boolean pressed = false;
    private boolean checked = false;
    protected String label;

    public Checkbox(int topLeftX, int topLeftY, int width, int height, String label) {
        super(topLeftX, topLeftY, width, height);
        this.label = I18n.func_135052_a((String)label, (Object[])new Object[0]);
        this.setTooltipIfFound(label);
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Checkbox.this.pressed && Checkbox.this.visible && Checkbox.this.enabled && Checkbox.this.isMouseOverElement(evt.mx, evt.my)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    Checkbox.this.checked = !Checkbox.this.checked;
                    Checkbox.this.onToggled();
                }
                Checkbox.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Checkbox.this.enabled && Checkbox.this.visible && Checkbox.this.isMouseOverElement(evt.mx, evt.my)) {
                    Checkbox.this.pressed = true;
                }
                return true;
            }
        });
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture1);
            int y = this.enabled ? (this.isMouseOverElement(mouseX, mouseY) ? 200 : 160) : 120;
            int x = this.checked ? 40 : 0;
            RenderTools.renderQuarteredTexture(256, 256, x, y, 40, 40, this.renderX, this.renderY, this.width, this.height);
            if (this.label != null) {
                int v = (this.height - 8) / 2;
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.label, (float)(this.renderX + this.width + 2), (float)(this.renderY + v), -1);
            }
        }
    }

    public void onToggled() {
    }

    public void setChecked(boolean val) {
        this.checked = val;
    }

    public boolean checked() {
        return this.checked;
    }
}

