/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class Button
extends GuiElement {
    private boolean pressed = false;
    protected String text;
    protected int textX;
    protected int textY;

    public Button(int topLeftX, int topLeftY, int width, int height, String text) {
        super(topLeftX, topLeftY, width, height);
        this.setText(text);
        this.setTooltipIfFound(text);
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Button.this.pressed && Button.this.enabled && Button.this.visible && Button.this.isMouseOverElement(evt.mx, evt.my)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    Button.this.onPressed(evt.mButton);
                }
                Button.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Button.this.enabled && Button.this.visible && Button.this.isMouseOverElement(evt.mx, evt.my)) {
                    Button.this.pressed = true;
                }
                return true;
            }
        });
    }

    public final void setText(String text) {
        this.text = I18n.func_135052_a((String)text, (Object[])new Object[0]);
        int tw = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text);
        if (tw > this.width) {
            this.width = tw;
        }
        this.textX = (this.width - tw) / 2;
        this.textY = (this.height - 8) / 2;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture1);
            int textureSize = 256;
            int startX = 0;
            int startY = this.enabled ? (this.isMouseOverElement(mouseX, mouseY) ? 80 : 40) : 0;
            int textColor = startY == 80 ? -1600085761 : -1;
            int usedWidth = 256;
            int usedHeight = 40;
            RenderTools.renderQuarteredTexture(textureSize, textureSize, startX, startY, usedWidth, usedHeight, this.renderX, this.renderY, this.width, this.height);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.text, (float)(this.renderX + this.textX), (float)(this.renderY + this.textY), textColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void onPressed() {
    }

    protected void onPressed(int mButton) {
        this.onPressed();
    }
}

