/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;

public class GuiFileSelect
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private String parentPathName = "";
    private String currentPath = "";
    private final boolean allowNewFiles;
    private CompositeScrolled area;
    private Text input;

    public GuiFileSelect(GuiContainerBase parent, String basePath, boolean allowNewFiles) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.currentPath = basePath;
        this.parentPathName = new File(basePath).getParent();
        this.allowNewFiles = allowNewFiles;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
        Button button = new Button(138, 22, 55, 12, "Accept");
        button.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiFileSelect.this.onAcceptClicked();
                }
                return true;
            }
        });
        this.addGuiElement(button);
        button = new Button(193, 22, 55, 12, "Cancel");
        button.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiFileSelect.this.onCancelClicked();
                }
                return true;
            }
        });
        this.addGuiElement(button);
        button = new Button(8, 22, 55, 12, "Back");
        button.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiFileSelect.this.onBackClicked();
                }
                return true;
            }
        });
        this.addGuiElement(button);
        this.input = new Text(8, 8, 160, "", this);
        this.input.addAllowedChar('.');
        this.addGuiElement(this.input);
    }

    private void handleFileClicked(String fileName) {
        File file = new File(this.currentPath, fileName);
        if (file.isDirectory()) {
            this.handleDirectorySelection(file.getAbsolutePath());
            this.input.setText("");
        } else {
            this.input.setText(fileName);
        }
        this.refreshGui();
    }

    private void handleDirectorySelection(String newPath) {
        if (newPath == null) {
            new Exception("Null path detected..").printStackTrace();
            return;
        }
        File file = new File(newPath);
        this.parentPathName = file.getParent();
        this.currentPath = newPath;
        this.refreshGui();
    }

    private void onAcceptClicked() {
        String name = this.input.getText();
        File selectedFile = new File(this.currentPath, name);
        if (this.allowNewFiles || selectedFile.exists()) {
            this.onFileSelected(selectedFile);
        }
        this.closeWindow();
    }

    private void closeWindow() {
        ((ContainerBase)((Object)this.getContainer())).setGui(this.parent);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
    }

    private void onCancelClicked() {
        this.closeWindow();
    }

    private void onBackClicked() {
        this.handleDirectorySelection(this.parentPathName);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        int totalHeight = 3;
        File file = new File(this.currentPath);
        File[] dirFiles = file.listFiles();
        if (dirFiles != null) {
            for (File f : dirFiles) {
                if (!f.isDirectory() && !f.isFile()) continue;
                Label label = new Label(8, totalHeight, f.getName());
                label.addNewListener(new Listener(4){

                    @Override
                    public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                        if (widget.isMouseOverElement(evt.mx, evt.my)) {
                            GuiFileSelect.this.handleFileClicked(((Label)widget).getText());
                        }
                        return true;
                    }
                });
                this.area.addGuiElement(label);
                totalHeight += 12;
            }
        }
        this.area.setAreaSize(totalHeight);
    }

    public void onFileSelected(File file) {
    }
}

