/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.datafixes;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;

public class TileOwnerFixer
implements IFixableData {
    private static final String NEW_OWNER_NAME_TAG = "ownerName";
    private static final String NEW_OWNER_ID_TAG = "ownerId";

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String id = compound.func_74779_i("id");
        try {
            switch (id) {
                case "minecraft:hand_cranked_generator_tile": {
                    compound.func_74778_a(NEW_OWNER_NAME_TAG, compound.func_74779_i("owner"));
                    break;
                }
                case "minecraft:town_hall_tile": 
                case "minecraft:auto_crafting_tile": 
                case "minecraft:warehouse_control_tile": 
                case "minecraft:quarry_tile": 
                case "minecraft:forestry_tile": 
                case "minecraft:crop_farm_tile": 
                case "minecraft:fruit_farm_tile": 
                case "minecraft:mushroom_farm_tile": 
                case "minecraft:animal_farm_tile": 
                case "minecraft:fish_farm_tile": 
                case "minecraft:reed_farm_tile": {
                    compound.func_74778_a(NEW_OWNER_NAME_TAG, compound.func_74779_i("owner"));
                    compound.func_186854_a(NEW_OWNER_ID_TAG, UUID.fromString(compound.func_74779_i(NEW_OWNER_ID_TAG)));
                    break;
                }
                case "minecraft:research_station_tile": {
                    compound.func_74778_a(NEW_OWNER_NAME_TAG, compound.func_74779_i("owningPlayer"));
                    compound.func_186854_a(NEW_OWNER_ID_TAG, UUID.fromString(compound.func_74779_i(NEW_OWNER_ID_TAG)));
                    break;
                }
                case "minecraft:mailbox_tile": 
                case "minecraft:structure_builder_ticked_tile": 
                case "minecraft:warehouse_stock_viewer_tile": {
                    compound.func_186854_a(NEW_OWNER_ID_TAG, UUID.fromString(compound.func_74779_i(NEW_OWNER_ID_TAG)));
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            AncientWarfareCore.LOG.error("Tile {} at x:{} y:{} z:{} has invalid owner UUID and will need to be removed.", (Object)id, (Object)x, (Object)y, (Object)z);
        }
        return compound;
    }
}

