/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting.wrappers;

import java.util.Optional;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;

public class RegularCraftingWrapper
implements ICraftingRecipe {
    private final IRecipe recipe;
    private final RecipeResourceLocation registryName;

    public RegularCraftingWrapper(IRecipe recipe) {
        this.recipe = recipe;
        if (recipe.getRegistryName() == null) {
            throw new IllegalArgumentException("Null registryName recipes are not allowed here");
        }
        this.registryName = new RecipeResourceLocation(RecipeResourceLocation.RecipeType.REGULAR, recipe.getRegistryName());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.recipe.func_192400_c();
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.recipe.func_77572_b(inv);
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipe.func_77571_b();
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting invCrafting) {
        return this.recipe.func_179532_b(invCrafting);
    }

    @Override
    public RecipeResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public Optional<String> getNeededResearch() {
        return Optional.empty();
    }

    @Override
    public int getRecipeWidth() {
        return this.recipe instanceof IShapedRecipe ? ((IShapedRecipe)this.recipe).getRecipeWidth() : 3;
    }

    @Override
    public int getRecipeHeight() {
        return this.recipe instanceof IShapedRecipe ? ((IShapedRecipe)this.recipe).getRecipeHeight() : 3;
    }
}

