/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;

public class ShapedResearchRecipe
extends ResearchRecipeBase {
    protected int width = 0;
    protected int height = 0;

    public ShapedResearchRecipe(String research, ItemStack output, CraftingHelper.ShapedPrimer primer) {
        super(research, (NonNullList<Ingredient>)primer.input, output);
        this.width = primer.width;
        this.height = primer.height;
    }

    @Override
    public boolean matches(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (Ingredient)this.getIngredients().get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.getIngredients().get(subX + subY * this.width);
                }
                if (target.apply(inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    @Override
    public IRecipe getCraftingRecipe() {
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.height = this.height;
        primer.width = this.width;
        primer.input = this.getIngredients();
        return (IRecipe)new ShapedOreRecipe(null, this.getRecipeOutput(), primer).setRegistryName(this.getRegistryName());
    }
}

