/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;
import net.shadowmage.ancientwarfare.core.crafting.ShapedResearchRecipe;
import net.shadowmage.ancientwarfare.core.crafting.ShapelessResearchRecipe;

public class ResearchRecipeFactory {
    public ResearchRecipeBase parse(JsonContext context, JsonObject json) {
        String type = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (type.equals("ancientwarfare:research_recipe")) {
            return this.parseShaped(context, json);
        }
        if (type.equals("ancientwarfare:shapeless_research_recipe")) {
            return this.parseShapeless(context, json);
        }
        return null;
    }

    private ResearchRecipeBase parseShapeless(JsonContext context, JsonObject json) {
        NonNullList ings = NonNullList.func_191196_a();
        String research = JsonUtils.func_151200_h((JsonObject)json, (String)"research");
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new ShapelessResearchRecipe(research, (NonNullList<Ingredient>)ings, result);
    }

    private ResearchRecipeBase parseShaped(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.height = recipe.getHeight();
        primer.width = recipe.getWidth();
        primer.input = recipe.func_192400_c();
        primer.mirrored = false;
        String research = JsonUtils.func_151200_h((JsonObject)json, (String)"research");
        return new ShapedResearchRecipe(research, recipe.func_77571_b(), primer);
    }
}

