/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;

public abstract class ResearchRecipeBase
extends IForgeRegistryEntry.Impl<ResearchRecipeBase> {
    private String neededResearch;
    private ItemStack output;
    private NonNullList<Ingredient> input;

    ResearchRecipeBase(String research, NonNullList<Ingredient> input, ItemStack output) {
        this.addResearch(research);
        this.input = input;
        this.output = output;
    }

    public String getNeededResearch() {
        return this.neededResearch;
    }

    public ItemStack getCraftingResult() {
        return this.output.func_77946_l();
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    private void addResearch(String name) {
        if (!ResearchRegistry.researchExists(name)) {
            throw new IllegalArgumentException("COULD NOT LOCATE RESEARCH GOAL FOR NAME: " + name);
        }
        this.neededResearch = name;
    }

    abstract boolean matches(@Nonnull InventoryCrafting var1, @Nonnull World var2);

    abstract IRecipe getCraftingRecipe();
}

