/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.container;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;
import net.shadowmage.ancientwarfare.core.crafting.wrappers.NoRecipeWrapper;
import net.shadowmage.ancientwarfare.core.inventory.SlotResearchCrafting;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketGui;
import net.shadowmage.ancientwarfare.core.tile.CraftingRecipeMemory;

public class ContainerCraftingRecipeMemory {
    private static final String RECIPE_TAG = "recipe";
    private static final String FORCE_SET_TAG = "forceSet";
    private final SlotResearchCrafting craftingSlot;
    private CraftingRecipeMemory craftingRecipeMemory;
    private boolean updatePending = false;
    private int selectedRecipeIndex = -1;
    private boolean recipeUpdateCooldown = false;
    private long cooldownTime = 0L;
    private boolean isOpening = false;
    private List<Slot> slots = new ArrayList<Slot>();
    private List<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();
    private final World world;

    public List<Slot> getSlots() {
        return this.slots;
    }

    public List<Slot> getCraftingMatrixSlots() {
        return this.slots.subList(2, this.slots.size());
    }

    public List<ItemStack> getCraftingStacks() {
        NonNullList ret = NonNullList.func_191196_a();
        this.getCraftingMatrixSlots().forEach(arg_0 -> ContainerCraftingRecipeMemory.lambda$getCraftingStacks$0((List)ret, arg_0));
        return ret;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftingRecipeMemory.craftMatrix;
    }

    public ContainerCraftingRecipeMemory(CraftingRecipeMemory craftingRecipeMemory, EntityPlayer player) {
        this.craftingRecipeMemory = craftingRecipeMemory;
        this.world = player.field_70170_p;
        InventoryCrafting inventory = craftingRecipeMemory.craftMatrix;
        this.craftingSlot = new SlotResearchCrafting(player, craftingRecipeMemory, inventory, (IInventory)craftingRecipeMemory.outputSlot, 0, 134, 26){

            public boolean func_82869_a(EntityPlayer player) {
                return ContainerCraftingRecipeMemory.this.canTakeStackFromOutput(player);
            }

            @Override
            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                OnTakeResult result = ContainerCraftingRecipeMemory.this.handleOnTake(player, stack);
                ItemStack ret = result.getStack();
                if (result.getResult() != EnumActionResult.SUCCESS) {
                    ret = super.func_190901_a(player, stack);
                }
                ContainerCraftingRecipeMemory.this.updateRecipes();
                ContainerCraftingRecipeMemory.this.updateSelectedRecipe();
                return ret;
            }
        };
        this.slots.add(this.craftingSlot);
        Object slot = new SlotItemHandler((IItemHandler)craftingRecipeMemory.bookSlot, 0, 8, 26){

            public boolean func_75214_a(ItemStack par1ItemStack) {
                return ItemResearchBook.getResearcherName(par1ItemStack) != null;
            }

            public void func_75218_e() {
                super.func_75218_e();
                ContainerCraftingRecipeMemory.this.updateRecipes();
                ContainerCraftingRecipeMemory.this.updateSelectedRecipe();
            }
        };
        this.slots.add((Slot)slot);
        for (int y1 = 0; y1 < 3; ++y1) {
            int y2 = y1 * 18 + 8;
            for (int x1 = 0; x1 < 3; ++x1) {
                int x2 = x1 * 18 + 8 + 54;
                int slotNum = y1 * 3 + x1;
                slot = new Slot((IInventory)inventory, slotNum, x2, y2){

                    public void func_75218_e() {
                        super.func_75218_e();
                        if (!ContainerCraftingRecipeMemory.this.isOpening) {
                            ContainerCraftingRecipeMemory.this.updateRecipes();
                            ContainerCraftingRecipeMemory.this.updateSelectedRecipe();
                        }
                    }
                };
                this.slots.add((Slot)slot);
            }
        }
    }

    protected boolean canTakeStackFromOutput(EntityPlayer player) {
        return false;
    }

    protected OnTakeResult handleOnTake(EntityPlayer player, ItemStack stack) {
        return new OnTakeResult(EnumActionResult.PASS, stack);
    }

    private void updateRecipes() {
        this.recipes = AWCraftingManager.findMatchingRecipes(this.craftingRecipeMemory.craftMatrix, this.world, this.craftingRecipeMemory.getCrafterName());
        this.recipes.sort(Comparator.comparing(r -> r.getRegistryName().toString()));
        this.updateSelectedIndex();
    }

    private void updateSelectedIndex() {
        if (this.recipes.stream().anyMatch(r -> r.getRegistryName().equals(this.craftingRecipeMemory.getRecipe().getRegistryName()))) {
            this.setSelectedRecipeIndex(this.recipes.indexOf(this.recipes.stream().filter(r -> r.getRegistryName().equals(this.craftingRecipeMemory.getRecipe().getRegistryName())).findFirst().orElseGet(null)));
        } else {
            this.setSelectedRecipeIndex(this.recipes.isEmpty() ? -1 : 0);
        }
    }

    public void nextRecipe() {
        if (this.recipes.size() > 1) {
            this.setSelectedRecipeIndex(this.selectedRecipeIndex + 1 < this.recipes.size() ? this.selectedRecipeIndex + 1 : 0);
            this.updateSelectedRecipe();
            this.updateServer();
        }
    }

    public void previousRecipe() {
        if (this.recipes.size() > 1) {
            this.setSelectedRecipeIndex(this.selectedRecipeIndex - 1 >= 0 ? this.selectedRecipeIndex - 1 : this.recipes.size() - 1);
            this.updateSelectedRecipe();
            this.updateServer();
        }
    }

    private void setSelectedRecipeIndex(int newIndex) {
        if (this.selectedRecipeIndex != newIndex) {
            this.updatePending = true;
        }
        this.selectedRecipeIndex = newIndex;
    }

    private boolean isUpdatePending() {
        return this.updatePending;
    }

    private void updateSelectedRecipe() {
        if (this.isInRecipeUpdateCooldown()) {
            return;
        }
        if (this.selectedRecipeIndex == -1) {
            this.craftingRecipeMemory.setRecipe(NoRecipeWrapper.INSTANCE);
        } else {
            this.craftingRecipeMemory.setRecipe(this.recipes.get(this.selectedRecipeIndex));
        }
    }

    private void updateServer() {
        if (this.isUpdatePending()) {
            this.updatePending = false;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a(RECIPE_TAG, this.craftingRecipeMemory.getRecipe().getRegistryName().toString());
            NetworkHandler.sendToServer(new PacketGui(data));
        }
    }

    public List<ICraftingRecipe> getRecipes() {
        return this.recipes;
    }

    public void setRecipe(ICraftingRecipe recipe, boolean forceSet) {
        if (forceSet || !this.isInRecipeUpdateCooldown() && this.recipes.stream().anyMatch(r -> r.getRegistryName().equals(recipe.getRegistryName()))) {
            this.craftingRecipeMemory.setRecipe(recipe);
            this.updateSelectedIndex();
        }
    }

    private boolean isInRecipeUpdateCooldown() {
        if (!this.world.field_72995_K) {
            return false;
        }
        if (this.recipeUpdateCooldown && this.world.func_72820_D() > this.cooldownTime) {
            this.recipeUpdateCooldown = false;
        }
        return this.recipeUpdateCooldown;
    }

    public void handleRecipeUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b(RECIPE_TAG)) {
            this.setRecipe(AWCraftingManager.getRecipe(RecipeResourceLocation.deserialize(tag.func_74779_i(RECIPE_TAG))), tag.func_74767_n(FORCE_SET_TAG));
            this.updateSelectedIndex();
            if (this.world.field_72995_K && tag.func_74764_b(FORCE_SET_TAG)) {
                this.recipeUpdateCooldown = true;
                this.cooldownTime = this.world.func_72820_D() + 20L;
            } else {
                this.updateClients(tag.func_74779_i(RECIPE_TAG));
            }
        }
    }

    private void updateClients(String recipeRegistryName) {
        this.updateClients(recipeRegistryName, false);
    }

    private void updateClients(String recipeRegistryName, boolean cooldown) {
        if (!this.world.field_72995_K && this.isUpdatePending()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a(RECIPE_TAG, recipeRegistryName);
            if (cooldown) {
                data.func_74757_a(FORCE_SET_TAG, true);
            }
            NetworkHandler.sendToAllPlayers(new PacketGui(data));
        }
    }

    public void updateClients() {
        this.updateClients(this.craftingRecipeMemory.getRecipe().getRegistryName().toString(), true);
    }

    public void setUpdatePending() {
        this.updatePending = true;
    }

    public void setOpening(boolean opening) {
        this.isOpening = opening;
    }

    @Nullable
    public String getCrafterName() {
        return this.craftingRecipeMemory.getCrafterName();
    }

    private static /* synthetic */ void lambda$getCraftingStacks$0(List ret, Slot slot) {
        ret.add(slot.func_75211_c());
    }

    public class OnTakeResult {
        private final EnumActionResult result;
        private final ItemStack stack;

        public OnTakeResult(EnumActionResult result, ItemStack stack) {
            this.result = result;
            this.stack = stack;
        }

        public EnumActionResult getResult() {
            return this.result;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

