/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public abstract class ModConfiguration {
    public static final String generalOptions = "01_shared_settings";
    public static final String serverOptions = "02_server_settings";
    public static final String clientOptions = "03_client_settings";
    public static final String configPathForFiles = "config/ancientwarfare/";
    protected final Configuration config;
    public boolean updatedVersion = false;
    public boolean autoExportOnUpdate = false;

    public ModConfiguration(Configuration config) {
        this.config = config;
        this.load();
    }

    public ModConfiguration(String modid) {
        this(ModConfiguration.getConfigFor(modid));
    }

    private void load() {
        this.initializeCategories();
        this.initializeValues();
        this.save();
    }

    protected abstract void initializeCategories();

    protected abstract void initializeValues();

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean updatedVersion() {
        return this.updatedVersion;
    }

    public boolean autoExportOnUpdate() {
        return this.autoExportOnUpdate;
    }

    public static Configuration getConfigFor(String modID) {
        return new Configuration(new File(configPathForFiles, modID + ".cfg"));
    }
}

