/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.config;

import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;

public class AWCoreStatics
extends ModConfiguration {
    public static final String KEY_ALT_ITEM_USE_1 = "keybind.awCore.alt.item.use.1";
    public static final String KEY_ALT_ITEM_USE_2 = "keybind.awCore.alt.item.use.2";
    public static final String KEY_ALT_ITEM_USE_3 = "keybind.awCore.alt.item.use.3";
    public static final String KEY_ALT_ITEM_USE_4 = "keybind.awCore.alt.item.use.4";
    public static final String KEY_ALT_ITEM_USE_5 = "keybind.awCore.alt.item.use.5";
    public static boolean DEBUG = true;
    public static final String resourcePath = "/assets/ancientwarfare/resources/";
    public static final String utilsExportPath = "config/ancientwarfare//export/";
    private static final String worldGenSettings = "04_world_gen_settings";
    private static final String researchSettings = "06_research";
    private static final String recipeDetailSettings = "08_recipe_details";
    private static final String recipeResearchDetails = "09_recipe_research_details";
    public static boolean useResearchSystem = true;
    public static boolean enableResearchResourceUse = true;
    public static double energyPerResearchUnit = 1.0;
    public static double researchPerTick = 1.0;
    public static boolean fireBlockBreakEvents = true;
    public static boolean includeResearchInChests = true;
    public static double energyPerWorkUnit = 50.0;

    public AWCoreStatics(String modid) {
        super(modid);
    }

    @Override
    public void initializeValues() {
        DEBUG = this.config.getBoolean("debug_ouput", "01_shared_settings", false, "Enable extra debug console output and runtime checks.\nCan degrade performance if left on and lead to large log files.");
        fireBlockBreakEvents = this.config.getBoolean("fire_block_break_events", "02_server_settings", fireBlockBreakEvents, "Fire Block Break Events If set to false, block-break-events will not be posted for _any_ operations\neffectively negating any block-protection mods/mechanims in place on the server.\nIf left at true, block-break events will be posted for any automation or vehicles\nwhich are changing blocks in the world.  Most will use a reference to their owners-name\nfor permissions systems.");
        includeResearchInChests = this.config.getBoolean("include_research_in_chests", "02_server_settings", includeResearchInChests, "Include Research In Dungeon Loot Chests\nIf set to true, Research Note items will be added to dungeon-chest loot tables.\nIf set to false, no research will be added.\nThis is the global setting.  Individual research may be toggled in the Research\nsection of the config file.");
        energyPerWorkUnit = this.config.get("02_server_settings", "energy_per_work_unit", energyPerWorkUnit, "Energy Per Work Unit\nDefault = 50\nHow much Torque energy is generated per worker work tick.\nThis is the base number and is further adjusted per worker by worker effectiveness.\nSetting to 0 or below effectively disables  workers.").getDouble();
        energyPerResearchUnit = this.config.get(researchSettings, "energy_used per_research_tick", energyPerResearchUnit, "Energy Per Research Unit\nDefault = 1\nHow much energy is consumed per research tick.\nResearch generally ticks every game-tick if being worked at.\nSetting to 0 will eliminate the energy/worker requirements for research.\nSetting to higher than 1 will increase the amount of energy needed for research,\nincreasing the amount of time/resources required for all research.").getDouble();
        useResearchSystem = this.config.getBoolean("use_research_system", researchSettings, useResearchSystem, "If set to false, research system will be disabled and all recipes will be available in normal crafting station.");
        enableResearchResourceUse = this.config.getBoolean("use_research_resources", researchSettings, enableResearchResourceUse, "If set to false, research system will not use resources for research.");
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment("01_shared_settings", "General Options\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment("02_server_settings", "Server Options\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.config.addCustomCategoryComment("03_client_settings", "Client Options\nAffect only client-side operations.  Many of these options can be set from the in-game Options GUI.\nServer admins can ignore these settings.");
        this.config.addCustomCategoryComment(worldGenSettings, "AW Core World Generation Settings\nServer-side only settings.  These settings affect world generation settings for AWCore.");
        this.config.addCustomCategoryComment(researchSettings, "Research Settings Section\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment(recipeDetailSettings, "Recipe Detail Settings Section\nConfigure recipe enable/disable per item.\nDisabling the recipe effectively disables that item.\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment(recipeResearchDetails, "Recipe Research Detail Settings Section\nConfigure enable/disable research for specific recipes.\nDisabling the research removes all research requirements for that item.\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
    }

    public static boolean isItemCraftable(Item item) {
        String name = item.getRegistryName().toString();
        return AWCoreStatics.get().getBoolean(name, recipeDetailSettings, true, "");
    }

    public static boolean isItemResearcheable(Item item) {
        String name = item.getRegistryName().toString();
        return AWCoreStatics.get().getBoolean(name, recipeResearchDetails, true, "");
    }

    public static void update() {
        AncientWarfareCore.statics.save();
    }

    public static Configuration get() {
        return AncientWarfareCore.statics.getConfig();
    }
}

