/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.compat.jei;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.core.container.ICraftingContainer;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class PacketTransferRecipe
extends PacketBase {
    private ICraftingRecipe recipe;

    public PacketTransferRecipe() {
    }

    public PacketTransferRecipe(ICraftingRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.func_180714_a(this.recipe.getRegistryName().toString());
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        this.recipe = AWCraftingManager.getRecipe(RecipeResourceLocation.deserialize(buffer.func_150789_c(256)));
    }

    @Override
    protected void execute(EntityPlayer player) {
        ICraftingContainer craftingContainer;
        if (player.field_71070_bA instanceof ICraftingContainer && (craftingContainer = (ICraftingContainer)player.field_71070_bA).pushCraftingMatrixToInventories()) {
            CombinedInvWrapper handler = new CombinedInvWrapper(craftingContainer.getInventories());
            NonNullList<ItemStack> resources = AWCraftingManager.getRecipeInventoryMatch(this.recipe, (IItemHandler)handler);
            List<Slot> slots = craftingContainer.getCraftingMemoryContainer().getCraftingMatrixSlots();
            for (int x = 0; x < this.recipe.getRecipeWidth(); ++x) {
                for (int y = 0; y < this.recipe.getRecipeHeight(); ++y) {
                    int slotIndex = y * 3 + x;
                    int ingredientIndex = y * this.recipe.getRecipeWidth() + x;
                    Slot slot = slots.get(slotIndex);
                    slot.func_75215_d((ItemStack)resources.get(ingredientIndex));
                }
            }
            craftingContainer.getCraftingMemoryContainer().setRecipe(this.recipe, true);
            craftingContainer.getCraftingMemoryContainer().setUpdatePending();
            craftingContainer.getCraftingMemoryContainer().updateClients();
            InventoryTools.removeItems((IItemHandler)handler, resources);
        }
    }
}

