/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.automation.container.ContainerWorksiteAutoCrafting;
import net.shadowmage.ancientwarfare.automation.init.AWAutomationBlocks;
import net.shadowmage.ancientwarfare.core.compat.jei.MultiRecipeTransferHandler;
import net.shadowmage.ancientwarfare.core.compat.jei.ResearchRecipeWrapper;
import net.shadowmage.ancientwarfare.core.compat.jei.ShapedResearchRecipeCategory;
import net.shadowmage.ancientwarfare.core.compat.jei.ShapedResearchRecipeWrapper;
import net.shadowmage.ancientwarfare.core.compat.jei.ShapelessResearchRecipeCategory;
import net.shadowmage.ancientwarfare.core.container.ContainerEngineeringStation;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;
import net.shadowmage.ancientwarfare.core.crafting.ShapedResearchRecipe;
import net.shadowmage.ancientwarfare.core.crafting.ShapelessResearchRecipe;
import net.shadowmage.ancientwarfare.core.init.AWCoreBlocks;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.init.AWStructureItems;
import net.shadowmage.ancientwarfare.vehicle.init.AWVehicleItems;

@JEIPlugin
public class AWJEIPlugin
implements IModPlugin {
    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{AWNPCItems.NPC_SPAWNER});
        subtypeRegistry.useNbtForSubtypes(new Item[]{Item.func_150898_a((Block)AWStructureBlocks.FIRE_PIT)});
        subtypeRegistry.useNbtForSubtypes(new Item[]{AWNPCItems.COIN});
        subtypeRegistry.useNbtForSubtypes(new Item[]{AWStructureItems.TOTEM_PART});
        subtypeRegistry.registerSubtypeInterpreter((Item)AWVehicleItems.SPAWNER, itemStack -> Integer.toString(itemStack.func_77960_j()) + ":" + (itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : ""));
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ShapedResearchRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ShapelessResearchRecipeCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        List shapedResearchRecipes = AWCraftingManager.getRecipes().stream().filter(r -> r instanceof ShapedResearchRecipe).map(r -> new ShapedResearchRecipeWrapper(registry.getJeiHelpers(), (ShapedResearchRecipe)((Object)r))).collect(Collectors.toList());
        registry.addRecipes(shapedResearchRecipes, "shaped_research_recipe");
        List shapelessResearchRecipes = AWCraftingManager.getRecipes().stream().filter(r -> r instanceof ShapelessResearchRecipe).map(r -> new ResearchRecipeWrapper<ResearchRecipeBase>(registry.getJeiHelpers().getStackHelper(), (ResearchRecipeBase)((Object)r))).collect(Collectors.toList());
        registry.addRecipes(shapelessResearchRecipes, "shapeless_research_recipe");
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        if (!shapedResearchRecipes.isEmpty()) {
            this.registerMultiRecipeTransferHandler(ContainerWorksiteAutoCrafting.class, "shaped_research_recipe", transferRegistry, registry.getJeiHelpers());
            this.registerMultiRecipeTransferHandler(ContainerWarehouseCraftingStation.class, "shaped_research_recipe", transferRegistry, registry.getJeiHelpers());
            this.registerMultiRecipeTransferHandler(ContainerEngineeringStation.class, "shaped_research_recipe", transferRegistry, registry.getJeiHelpers());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.AUTO_CRAFTING), new String[]{"shaped_research_recipe"});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.WAREHOUSE_CRAFTING), new String[]{"shaped_research_recipe"});
            registry.addRecipeCatalyst((Object)new ItemStack(AWCoreBlocks.ENGINEERING_STATION), new String[]{"shaped_research_recipe"});
        }
        if (!shapelessResearchRecipes.isEmpty()) {
            this.registerMultiRecipeTransferHandler(ContainerWorksiteAutoCrafting.class, "shapeless_research_recipe", transferRegistry, registry.getJeiHelpers());
            this.registerMultiRecipeTransferHandler(ContainerWarehouseCraftingStation.class, "shapeless_research_recipe", transferRegistry, registry.getJeiHelpers());
            this.registerMultiRecipeTransferHandler(ContainerEngineeringStation.class, "shapeless_research_recipe", transferRegistry, registry.getJeiHelpers());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.AUTO_CRAFTING), new String[]{"shapeless_research_recipe"});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.WAREHOUSE_CRAFTING), new String[]{"shapeless_research_recipe"});
            registry.addRecipeCatalyst((Object)new ItemStack(AWCoreBlocks.ENGINEERING_STATION), new String[]{"shapeless_research_recipe"});
        }
        this.registerMultiRecipeTransferHandler(ContainerWorksiteAutoCrafting.class, "minecraft.crafting", transferRegistry, registry.getJeiHelpers());
        this.registerMultiRecipeTransferHandler(ContainerWarehouseCraftingStation.class, "minecraft.crafting", transferRegistry, registry.getJeiHelpers());
        this.registerMultiRecipeTransferHandler(ContainerEngineeringStation.class, "minecraft.crafting", transferRegistry, registry.getJeiHelpers());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.AUTO_CRAFTING), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)AWAutomationBlocks.WAREHOUSE_CRAFTING), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack(AWCoreBlocks.ENGINEERING_STATION), new String[]{"minecraft.crafting"});
    }

    private <C extends Container> void registerMultiRecipeTransferHandler(Class<C> containerClass, String recipeCategoryUid, IRecipeTransferRegistry transferRegistry, IJeiHelpers jeiHelpers) {
        MultiRecipeTransferHandler<C> handler = new MultiRecipeTransferHandler<C>(containerClass, jeiHelpers.recipeTransferHandlerHelper());
        transferRegistry.addRecipeTransferHandler(handler, recipeCategoryUid);
    }
}

