/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.block.BlockBaseCore;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.gui.research.GuiResearchStation;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.ResearchStationRenderer;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.tile.TileResearchStation;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockResearchStation
extends BlockBaseCore
implements BlockRotationHandler.IRotatableBlock,
IBakeryProvider,
IClientRegister {
    public BlockResearchStation() {
        super(Material.field_151576_e, "research_station");
        this.func_149711_c(2.0f);
        AncientWarfareCore.proxy.addClientRegister(this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{CoreProperties.UNLISTED_HORIZONTAL_FACING}).build();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = WorldTools.getTile(world, pos, TileResearchStation.class).map(TileResearchStation::getPrimaryFacing).orElse(EnumFacing.NORTH);
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty(CoreProperties.UNLISTED_HORIZONTAL_FACING, (Object)facing);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileResearchStation();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return WorldTools.clickInteractableTileWithHand(world, pos, player, hand);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        NetworkHandler.registerGui(12, GuiResearchStation.class);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return ResearchStationRenderer.MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)ResearchStationRenderer.MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return ResearchStationRenderer.INSTANCE.sprite;
            }
        });
        ModelLoaderHelper.registerItem(this, ResearchStationRenderer.MODEL_LOCATION);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(CoreProperties.UNLISTED_HORIZONTAL_FACING).build());
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return ResearchStationRenderer.INSTANCE;
    }
}

