/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.block.BlockBaseCore;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.gui.crafting.GuiEngineeringStation;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.EngineeringStationRenderer;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.tile.TileEngineeringStation;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockEngineeringStation
extends BlockBaseCore
implements IClientRegister,
IBakeryProvider,
BlockRotationHandler.IRotatableBlock {
    public BlockEngineeringStation() {
        super(Material.field_151576_e, "engineering_station");
        this.func_149711_c(2.0f);
        AncientWarfareCore.proxy.addClientRegister(this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{CoreProperties.UNLISTED_HORIZONTAL_FACING}).build();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = WorldTools.getTile(world, pos, TileEngineeringStation.class).map(TileEngineeringStation::getPrimaryFacing).orElse(EnumFacing.NORTH);
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty(CoreProperties.UNLISTED_HORIZONTAL_FACING, (Object)facing);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEngineeringStation();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 0, pos);
        }
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        WorldTools.getTile((IBlockAccess)world, pos, TileEngineeringStation.class).ifPresent(TileEngineeringStation::onBlockBreak);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        NetworkHandler.registerGui(0, GuiEngineeringStation.class);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return EngineeringStationRenderer.MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)EngineeringStationRenderer.MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return EngineeringStationRenderer.INSTANCE.sprite;
            }
        });
        ModelLoaderHelper.registerItem(this, EngineeringStationRenderer.MODEL_LOCATION);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(CoreProperties.UNLISTED_HORIZONTAL_FACING).build());
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return EngineeringStationRenderer.INSTANCE;
    }
}

