/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.automation.registry.TreeFarmRegistry;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteFarm;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.IBlockExtraDrop;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ISapling;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteTreeFarm
extends TileWorksiteFarm {
    private boolean hasShears;
    private final Set<BlockPos> blocksToShear = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> leafBlocksToChop = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> trunkBlocksToChop = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> blocksToPlant = new HashSet<BlockPos>();
    private final Set<BlockPos> blocksToFertilize = new HashSet<BlockPos>();
    private final IItemHandler inventoryForDrops = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.plantableInventory, this.mainInventory});
    private static final IWorksiteAction SHEAR_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction CHOP_TRUNK_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 2.0;
    private static final IWorksiteAction CHOP_LEAF_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 10.0;
    private static final IWorksiteAction PLANT_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BONEMEAL_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;

    @Override
    protected boolean isPlantable(ItemStack stack) {
        return TreeFarmRegistry.isPlantable(stack);
    }

    @Override
    protected boolean isMiscItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151097_aZ || super.isMiscItem(stack);
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.blocksToFertilize);
        this.validateCollection(this.trunkBlocksToChop);
        this.validateCollection(this.leafBlocksToChop);
        this.validateCollection(this.blocksToPlant);
        if (!this.hasShears) {
            this.blocksToShear.clear();
        }
        this.func_70296_d();
    }

    @Override
    protected void countResources() {
        super.countResources();
        this.hasShears = InventoryTools.getCountOf((IItemHandler)this.miscInventory, s -> s.func_77973_b() == Items.field_151097_aZ) > 0;
    }

    private boolean bonemealBlock() {
        if (this.bonemealCount <= 0 || this.blocksToFertilize.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = this.blocksToFertilize.iterator();
        BlockPos position = it.next();
        it.remove();
        IBlockState state = this.field_145850_b.func_180495_p(position);
        return this.canFertilize(this.field_145850_b, position, state) && this.fertilize(position);
    }

    private boolean plant() {
        if (this.plantableCount <= 0 || this.blocksToPlant.isEmpty()) {
            return false;
        }
        Optional<Tuple> plantable = InventoryTools.stream((IItemHandler)this.plantableInventory).map(p -> new Tuple(p, TreeFarmRegistry.getSapling(p))).filter(t -> ((Optional)t.func_76340_b()).isPresent()).map(t -> new Tuple(t.func_76341_a(), ((Optional)t.func_76340_b()).get())).findFirst();
        if (plantable.isPresent()) {
            Iterator<BlockPos> it = this.blocksToPlant.iterator();
            BlockPos position = it.next();
            it.remove();
            ItemStack stack = (ItemStack)plantable.get().func_76341_a();
            ISapling sapling = (ISapling)plantable.get().func_76340_b();
            if (this.canReplace(position) && this.tryPlantingSapling(position, stack, sapling)) {
                InventoryTools.removeItems((IItemHandler)this.plantableInventory, stack, 1);
                return true;
            }
        }
        return false;
    }

    private boolean tryPlantingSapling(BlockPos position, ItemStack stack, ISapling sapling) {
        return sapling.isRightClick() ? BlockTools.placeItemBlockRightClick(stack.func_77946_l(), this.field_145850_b, position) : this.tryPlace(stack.func_77946_l(), position, EnumFacing.UP) || this.tryPlace(stack.func_77946_l(), position, EnumFacing.DOWN);
    }

    private boolean chopBlock(boolean wood) {
        if (wood && this.trunkBlocksToChop.isEmpty() || !wood && this.leafBlocksToChop.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = wood ? this.trunkBlocksToChop.iterator() : this.leafBlocksToChop.iterator();
        BlockPos position = it.next();
        IBlockState state = this.field_145850_b.func_180495_p(position);
        if (state.func_185904_a() == Material.field_151579_a) {
            it.remove();
            return false;
        }
        IBlockExtraDrop extraDrop = TreeFarmRegistry.getBlockExtraDrop(state);
        NonNullList<ItemStack> extraDrops = extraDrop.getDrops((IBlockAccess)this.field_145850_b, position, state, this.getFortune());
        if (!this.harvestBlock(position)) {
            return false;
        }
        it.remove();
        InventoryTools.insertOrDropItems(this.inventoryForDrops, extraDrops, this.field_145850_b, position);
        return true;
    }

    private boolean shearBlock() {
        Optional<ItemStack> shears;
        if (!this.hasShears || this.blocksToShear.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = this.blocksToShear.iterator();
        BlockPos position = it.next();
        it.remove();
        Block block = this.field_145850_b.func_180495_p(position).func_177230_c();
        return block instanceof IShearable && (shears = InventoryTools.stream((IItemHandler)this.miscInventory).filter(s -> s.func_77973_b() instanceof ItemShears).findFirst()).isPresent() && this.shear(position, (IShearable)block, shears.get());
    }

    private boolean shear(BlockPos position, IShearable block, ItemStack shears) {
        if (block.isShearable(shears, (IBlockAccess)this.field_145850_b, position)) {
            List<ItemStack> drops = block.onSheared(shears, (IBlockAccess)this.field_145850_b, position, this.getFortune());
            drops = InventoryTools.insertItems((IItemHandler)this.plantableInventory, drops, false);
            InventoryTools.insertOrDropItems((IItemHandler)this.mainInventory, drops, this.field_145850_b, this.field_174879_c);
            this.field_145850_b.func_175698_g(position);
            return true;
        }
        return false;
    }

    private void addTreeBlocks(IBlockState state, BlockPos basePos) {
        this.field_145850_b.field_72984_F.func_76320_a("TreeFinder");
        ITree tree = TreeFarmRegistry.getTreeScanner(state).scanTree(this.field_145850_b, basePos);
        List<BlockPos> leafBlocks = tree.getLeafPositions();
        if (this.hasShears) {
            this.blocksToShear.addAll(leafBlocks);
        } else {
            this.leafBlocksToChop.addAll(leafBlocks);
        }
        List<BlockPos> trunkBlocks = tree.getTrunkPositions();
        this.trunkBlocksToChop.addAll(trunkBlocks);
        if (!leafBlocks.isEmpty() || !trunkBlocks.isEmpty()) {
            this.func_70296_d();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FORESTRY;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 25, this.field_174879_c);
        }
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagList chopList;
        super.func_189515_b(tag);
        if (!this.trunkBlocksToChop.isEmpty()) {
            chopList = new NBTTagList();
            for (BlockPos position : this.trunkBlocksToChop) {
                chopList.func_74742_a((NBTBase)new NBTTagLong(position.func_177986_g()));
            }
            tag.func_74782_a("targetList", (NBTBase)chopList);
        }
        if (!this.leafBlocksToChop.isEmpty()) {
            chopList = new NBTTagList();
            for (BlockPos position : this.leafBlocksToChop) {
                chopList.func_74742_a((NBTBase)new NBTTagLong(position.func_177986_g()));
            }
            tag.func_74782_a("targetLeafList", (NBTBase)chopList);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i;
        NBTTagList chopList;
        super.func_145839_a(tag);
        this.trunkBlocksToChop.clear();
        if (tag.func_74764_b("targetList")) {
            chopList = tag.func_150295_c("targetList", 4);
            for (i = 0; i < chopList.func_74745_c(); ++i) {
                this.trunkBlocksToChop.add(BlockPos.func_177969_a((long)((NBTTagLong)chopList.func_179238_g(i)).func_150291_c()));
            }
        }
        if (tag.func_74764_b("targetLeafList")) {
            chopList = tag.func_150295_c("targetLeafList", 4);
            for (i = 0; i < chopList.func_74745_c(); ++i) {
                this.leafBlocksToChop.add(BlockPos.func_177969_a((long)((NBTTagLong)chopList.func_179238_g(i)).func_150291_c()));
            }
        }
    }

    @Override
    protected void scanBlockPosition(BlockPos scanPos) {
        if (this.canReplace(scanPos)) {
            IBlockState state = this.field_145850_b.func_180495_p(scanPos.func_177977_b());
            if (TreeFarmRegistry.isSoil(state) || state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, scanPos.func_177977_b()) && TreeFarmRegistry.isSoil(this.field_145850_b.func_180495_p(scanPos.func_177984_a()))) {
                this.blocksToPlant.add(scanPos);
            }
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(scanPos);
            if (this.canFertilize(this.field_145850_b, scanPos, state)) {
                this.blocksToFertilize.add(scanPos);
            } else if (state.func_185904_a() != Material.field_151579_a && this.trunkBlocksToChop.isEmpty() && this.leafBlocksToChop.isEmpty()) {
                this.addTreeBlocks(state, scanPos);
            }
        }
    }

    private boolean canFertilize(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof IGrowable && ((IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, world.field_72995_K);
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        if (this.hasShears && !this.blocksToShear.isEmpty()) {
            return Optional.of(SHEAR_ACTION);
        }
        if (!this.leafBlocksToChop.isEmpty()) {
            return Optional.of(CHOP_LEAF_ACTION);
        }
        if (!this.trunkBlocksToChop.isEmpty()) {
            return Optional.of(CHOP_TRUNK_ACTION);
        }
        if (this.bonemealCount > 0 && !this.blocksToFertilize.isEmpty()) {
            return Optional.of(BONEMEAL_ACTION);
        }
        if (this.plantableCount > 0 && !this.blocksToPlant.isEmpty()) {
            return Optional.of(PLANT_ACTION);
        }
        return Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (action == SHEAR_ACTION) {
            return this.shearBlock();
        }
        if (action == CHOP_TRUNK_ACTION) {
            return this.chopBlock(true);
        }
        if (action == CHOP_LEAF_ACTION) {
            return this.chopBlock(false);
        }
        if (action == BONEMEAL_ACTION) {
            return this.bonemealBlock();
        }
        if (action == PLANT_ACTION) {
            return this.plant();
        }
        return false;
    }
}

