/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;

public class Branch
implements ITree {
    private final List<Branch> childBranches = new ArrayList<Branch>();
    private final List<BlockPos> trunkPositions = new ArrayList<BlockPos>();
    private boolean mature;

    public void addChildBranch(Branch branch) {
        this.childBranches.add(branch);
    }

    public void addTrunkPos(BlockPos pos) {
        this.trunkPositions.add(0, pos);
    }

    public void setMature() {
        this.mature = true;
    }

    @Override
    public List<BlockPos> getTrunkPositions() {
        List ret = this.childBranches.stream().map(Branch::getTrunkPositions).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        if (this.mature) {
            ret.addAll(this.trunkPositions);
        }
        return ret;
    }

    private boolean isMature() {
        return this.mature;
    }

    @Override
    public List<BlockPos> getLeafPositions() {
        return Collections.emptyList();
    }

    public void updateMature() {
        if (this.childBranches.stream().allMatch(Branch::isMature)) {
            this.setMature();
        }
    }
}

