/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.automation.registry.FruitFarmRegistry;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteFarm;
import net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm.IFruit;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteFruitFarm
extends TileWorksiteFarm {
    private static final int MAX_HEIGHT_SEARCH = 7;
    private Set<BlockPos> blocksToPick = new LinkedHashSet<BlockPos>();
    private Set<BlockPos> blocksToPlant = new LinkedHashSet<BlockPos>();
    private Set<BlockPos> blocksToBoneMeal = new LinkedHashSet<BlockPos>();
    private final IItemHandler inventoryForDrops = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.plantableInventory, this.mainInventory});
    private static final IWorksiteAction PICK_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction PLANT_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BONEMEAL_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;

    @Override
    public void onBoundsAdjusted() {
        super.onBoundsAdjusted();
        this.validateCollection(this.blocksToPick);
        this.validateCollection(this.blocksToPlant);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 53, this.field_174879_c);
        }
        return true;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    protected boolean isPlantable(ItemStack stack) {
        return FruitFarmRegistry.isPlantable(stack);
    }

    @Override
    protected void scanBlockPosition(BlockPos pos) {
        BlockPos currentPos = pos;
        while (currentPos.func_177956_o() < pos.func_177956_o() + 7) {
            IBlockState state = this.field_145850_b.func_180495_p(currentPos);
            if (FruitFarmRegistry.getPickable(state).isRipe(state)) {
                this.blocksToPick.add(currentPos);
            }
            BlockPos curPos = currentPos;
            InventoryTools.stream((IItemHandler)this.plantableInventory).filter(s -> FruitFarmRegistry.getPlantable(s).canPlant(this.field_145850_b, curPos, state)).forEach(s -> this.blocksToPlant.add(curPos));
            if (this.canBoneMeal(this.field_145850_b, currentPos, state)) {
                this.blocksToBoneMeal.add(currentPos);
            }
            currentPos = currentPos.func_177984_a();
        }
    }

    private boolean canBoneMeal(World world, BlockPos currentPos, IBlockState state) {
        return state.func_177230_c() instanceof IGrowable && ((IGrowable)state.func_177230_c()).func_176473_a(world, currentPos, state, world.field_72995_K);
    }

    private boolean boneMeal() {
        if (this.blocksToBoneMeal.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = this.blocksToBoneMeal.iterator();
        BlockPos pos = it.next();
        it.remove();
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177230_c() instanceof IGrowable && this.fertilize(pos);
    }

    private boolean plantFruits() {
        if (this.blocksToPlant.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = this.blocksToPlant.iterator();
        BlockPos plantPos = it.next();
        it.remove();
        Optional<IFruit> plantableFruit = InventoryTools.stream((IItemHandler)this.plantableInventory).map(FruitFarmRegistry::getPlantable).filter(p -> p.canPlant(this.field_145850_b, plantPos, this.field_145850_b.func_180495_p(plantPos))).findFirst();
        return plantableFruit.isPresent() && plantableFruit.get().plant(this.field_145850_b, plantPos);
    }

    private boolean pickFruits() {
        if (this.blocksToPick.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> it = this.blocksToPick.iterator();
        BlockPos pickPos = it.next();
        it.remove();
        IBlockState state = this.field_145850_b.func_180495_p(pickPos);
        IFruit pickable = FruitFarmRegistry.getPickable(state);
        return pickable.pick(this.field_145850_b, state, pickPos, this.getFortune(), this.inventoryForDrops);
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        if (!this.blocksToPick.isEmpty()) {
            return Optional.of(PICK_ACTION);
        }
        if (!this.blocksToPlant.isEmpty()) {
            return Optional.of(PLANT_ACTION);
        }
        if (!this.blocksToBoneMeal.isEmpty()) {
            return Optional.of(BONEMEAL_ACTION);
        }
        return Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (action == PICK_ACTION) {
            return this.pickFruits();
        }
        if (action == PLANT_ACTION) {
            return this.plantFruits();
        }
        if (action == BONEMEAL_ACTION) {
            return this.boneMeal();
        }
        return false;
    }
}

