/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm.IFruit;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.PropertyState;
import net.shadowmage.ancientwarfare.core.util.parsing.PropertyStateMatcher;

public class FruitPicked
implements IFruit {
    private BlockStateMatcher stateMatcher;
    private PropertyStateMatcher ripeStateMatcher;
    private PropertyState newState;

    public FruitPicked(BlockStateMatcher stateMatcher, PropertyStateMatcher ripeStateMatcher, PropertyState newState) {
        this.stateMatcher = stateMatcher;
        this.ripeStateMatcher = ripeStateMatcher;
        this.newState = newState;
    }

    @Override
    public boolean matches(IBlockState state) {
        return this.stateMatcher.test(state);
    }

    @Override
    public boolean isRipe(IBlockState state) {
        return this.ripeStateMatcher.test(state);
    }

    @Override
    public boolean pick(World world, IBlockState state, BlockPos pos, int fortune, IItemHandler inventory) {
        NonNullList<ItemStack> drops = this.getDrops(world, state, pos, fortune);
        if (drops.isEmpty() || !InventoryTools.canInventoryHold(inventory, drops)) {
            return false;
        }
        world.func_175656_a(pos, this.newState.update(state));
        this.putInInventory(world, pos, inventory, drops);
        return true;
    }

    protected NonNullList<ItemStack> getDrops(World world, IBlockState state, BlockPos pos, int fortune) {
        return InventoryTools.toNonNullList(state.func_177230_c().getDrops((IBlockAccess)world, pos, state, fortune));
    }

    protected void putInInventory(World world, BlockPos pos, IItemHandler inventory, NonNullList<ItemStack> drops) {
        InventoryTools.insertOrDropItems(inventory, drops, world, pos);
    }

    @Override
    public boolean isPlantable() {
        return false;
    }
}

