/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.fruitfarm.IFruit;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.ItemStackMatcher;

public class FruitCocoa
implements IFruit {
    private BlockStateMatcher stateMatcher = new BlockStateMatcher(Blocks.field_150375_by);
    private ItemStackMatcher stackMatcher = new ItemStackMatcher.Builder(Items.field_151100_aR).setMeta(EnumDyeColor.BROWN.func_176767_b()).build();

    @Override
    public boolean matches(IBlockState state) {
        return this.stateMatcher.test(state);
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.stackMatcher.test(stack);
    }

    @Override
    public boolean canPlant(World world, BlockPos pos, IBlockState state) {
        return world.func_175623_d(pos) && Stream.of(EnumFacing.field_176754_o).anyMatch(h -> this.isJungleLog(world.func_180495_p(pos.func_177972_a(h))));
    }

    private boolean isJungleLog(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150364_r && state.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }

    @Override
    public boolean plant(World world, BlockPos plantPos) {
        if (!world.func_175623_d(plantPos)) {
            return false;
        }
        Optional<EnumFacing> facing = Stream.of(EnumFacing.field_176754_o).filter(h -> this.isJungleLog(world.func_180495_p(plantPos.func_177972_a(h)))).findFirst();
        return facing.isPresent() && this.plantBean(world, plantPos, facing.get());
    }

    private boolean plantBean(World world, BlockPos pos, EnumFacing facing) {
        return world.func_175656_a(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public boolean isRipe(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockCocoa.field_176501_a) == 2;
    }

    @Override
    public boolean pick(World world, IBlockState state, BlockPos pos, int fortune, IItemHandler inventory) {
        NonNullList drops = NonNullList.func_191196_a();
        Blocks.field_150375_by.getDrops(drops, (IBlockAccess)world, pos, state, fortune);
        if (!InventoryTools.canInventoryHold(inventory, (List<ItemStack>)drops)) {
            return false;
        }
        IBlockState newState = state.func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0));
        world.func_175656_a(pos, newState);
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)newState));
        InventoryTools.removeItem((NonNullList<ItemStack>)drops, s -> s.func_77973_b() == Items.field_151100_aR && EnumDyeColor.func_176766_a((int)s.func_77960_j()) == EnumDyeColor.BROWN, 1);
        InventoryTools.insertOrDropItems(inventory, (List<ItemStack>)drops, world, pos);
        return true;
    }

    @Override
    public boolean isPlantable() {
        return true;
    }
}

