/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.automation.registry.CropFarmRegistry;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteFarm;
import net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm.ICrop;
import net.shadowmage.ancientwarfare.core.entity.AWFakePlayer;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;

public class WorkSiteCropFarm
extends TileWorksiteFarm {
    private final Set<BlockPos> blocksToTill = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> blocksToHarvest = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> blocksToPlant = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> blocksToFertilize = new LinkedHashSet<BlockPos>();
    private final IItemHandler inventoryForDrops = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.plantableInventory, this.mainInventory});
    private static final IWorksiteAction PLANT_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 5.0;
    private static final IWorksiteAction FERTILIZE_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 5.0;
    private static final IWorksiteAction TILL_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 5.0;
    private static final IWorksiteAction HARVEST_ACTION = e -> IWorkSite.WorksiteImplementation.getEnergyPerActivation(e) / 5.0;

    @Override
    protected boolean isPlantable(ItemStack stack) {
        return CropFarmRegistry.getCrop(stack).isPlantable(stack);
    }

    @Override
    protected boolean isFarmable(Block block, BlockPos farmablePos) {
        if (super.isFarmable(block, farmablePos)) {
            return ((IPlantable)block).getPlantType((IBlockAccess)this.field_145850_b, farmablePos) == EnumPlantType.Crop;
        }
        return block instanceof BlockCrops || block instanceof BlockStem;
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.blocksToFertilize);
        this.validateCollection(this.blocksToHarvest);
        this.validateCollection(this.blocksToPlant);
        this.validateCollection(this.blocksToTill);
    }

    @Override
    protected void scanBlockPosition(BlockPos position) {
        IBlockState state = this.field_145850_b.func_180495_p(position);
        Block block = this.field_145850_b.func_180495_p(position).func_177230_c();
        if (block.func_176200_f((IBlockAccess)this.field_145850_b, position)) {
            IBlockState stateDown = this.field_145850_b.func_180495_p(position.func_177977_b());
            if (CropFarmRegistry.isTillable(stateDown)) {
                this.blocksToTill.add(position.func_177977_b());
            } else if (CropFarmRegistry.isSoil(stateDown)) {
                this.blocksToPlant.add(position);
            }
        }
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        ICrop crop = CropFarmRegistry.getCrop(state);
        this.blocksToHarvest.addAll(crop.getPositionsToHarvest(this.field_145850_b, position, state));
        if (crop.canBeFertilized(state, this.field_145850_b, position)) {
            this.blocksToFertilize.add(position);
        }
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 27, this.field_174879_c);
        }
        return true;
    }

    private boolean hasToPlant() {
        return this.plantableCount > 0 && !this.blocksToPlant.isEmpty();
    }

    private boolean hasToFertilize() {
        return this.bonemealCount > 0 && !this.blocksToFertilize.isEmpty();
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        if (!this.blocksToHarvest.isEmpty()) {
            return Optional.of(HARVEST_ACTION);
        }
        if (this.hasToFertilize()) {
            return Optional.of(FERTILIZE_ACTION);
        }
        if (this.hasToPlant()) {
            return Optional.of(PLANT_ACTION);
        }
        if (!this.blocksToTill.isEmpty()) {
            return Optional.of(TILL_ACTION);
        }
        return Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (action == TILL_ACTION) {
            return this.tryTill();
        }
        if (action == HARVEST_ACTION) {
            return this.tryHarvest();
        }
        if (action == PLANT_ACTION) {
            return this.tryPlant();
        }
        if (action == FERTILIZE_ACTION) {
            return this.tryFertilize();
        }
        return false;
    }

    private boolean tryFertilize() {
        BlockPos position;
        Iterator<BlockPos> it = this.blocksToFertilize.iterator();
        while (it.hasNext() && (position = it.next()) != null) {
            it.remove();
            IBlockState state = this.field_145850_b.func_180495_p(position);
            Block block = state.func_177230_c();
            if (!(block instanceof IGrowable)) continue;
            for (int slot = 0; slot < this.miscInventory.getSlots(); ++slot) {
                ItemStack stack = this.miscInventory.getStackInSlot(slot);
                if (stack.func_190926_b() || !this.isBonemeal(stack)) continue;
                ItemStack clone = stack.func_77946_l();
                if (ItemDye.applyBonemeal((ItemStack)clone, (World)this.field_145850_b, (BlockPos)position, (EntityPlayer)AWFakePlayer.get(this.field_145850_b), (EnumHand)EnumHand.MAIN_HAND)) {
                    this.miscInventory.extractItem(slot, 1, false);
                    this.field_145850_b.func_175718_b(2005, position, 0);
                }
                if ((block = this.field_145850_b.func_180495_p(position).func_177230_c()) instanceof IGrowable) {
                    if (((IGrowable)block).func_176473_a(this.field_145850_b, position, state, this.field_145850_b.field_72995_K)) {
                        this.blocksToFertilize.add(position);
                    } else if (this.isFarmable(block, position)) {
                        this.blocksToHarvest.add(position);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean tryPlant() {
        BlockPos position;
        Iterator<BlockPos> it = this.blocksToPlant.iterator();
        while (it.hasNext() && (position = it.next()) != null) {
            it.remove();
            if (!this.canReplace(position)) continue;
            for (int slot = 0; slot < this.plantableInventory.getSlots(); ++slot) {
                ItemStack clone;
                ItemStack stack = this.plantableInventory.getStackInSlot(slot);
                if (stack.func_190926_b() || !this.isPlantable(stack) || !this.tryPlace(clone = stack.func_77946_l(), position, EnumFacing.UP)) continue;
                this.plantableInventory.extractItem(slot, 1, false);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean tryHarvest() {
        BlockPos position;
        Iterator<BlockPos> it = this.blocksToHarvest.iterator();
        if (it.hasNext() && (position = it.next()) != null) {
            it.remove();
            IBlockState state = this.field_145850_b.func_180495_p(position);
            ICrop crop = CropFarmRegistry.getCrop(state);
            return crop.harvest(this.field_145850_b, state, position, this.getFortune(), this.inventoryForDrops);
        }
        return false;
    }

    private boolean tryTill() {
        BlockPos position;
        Iterator<BlockPos> it = this.blocksToTill.iterator();
        while (it.hasNext() && (position = it.next()) != null) {
            it.remove();
            IBlockState state = this.field_145850_b.func_180495_p(position);
            if (!CropFarmRegistry.isTillable(state) || !this.canReplace(position.func_177984_a())) continue;
            this.field_145850_b.func_175656_a(position, CropFarmRegistry.getTilledState(state));
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

