/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.cropfarm.CropDefault;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;

public class CropKeepBottom
extends CropDefault {
    private static final int MAX_HEIGHT = 10;
    private BlockStateMatcher stateMatcher;

    public CropKeepBottom(BlockStateMatcher stateMatcher) {
        this.stateMatcher = stateMatcher;
    }

    @Override
    public boolean harvest(World world, IBlockState state, BlockPos pos, int fortune, IItemHandler inventory) {
        NonNullList stacks = NonNullList.func_191196_a();
        Map<BlockPos, IBlockState> harvestPositions = this.getHarvestPositions(world, pos);
        this.getDrops(harvestPositions, (NonNullList<ItemStack>)stacks, world, fortune);
        if (!InventoryTools.canInventoryHold(inventory, (List<ItemStack>)stacks)) {
            return false;
        }
        if (!this.breakCrop(harvestPositions, world)) {
            return false;
        }
        InventoryTools.insertOrDropItems(inventory, (List<ItemStack>)stacks, world, pos);
        return true;
    }

    private void getDrops(Map<BlockPos, IBlockState> harvestPositions, NonNullList<ItemStack> stacks, World world, int fortune) {
        for (Map.Entry<BlockPos, IBlockState> entry : harvestPositions.entrySet()) {
            this.getDrops(stacks, world, entry.getKey(), entry.getValue(), fortune);
        }
    }

    private boolean breakCrop(Map<BlockPos, IBlockState> harvestPositions, World world) {
        for (Map.Entry<BlockPos, IBlockState> entry : harvestPositions.entrySet()) {
            if (this.breakCrop(world, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private Map<BlockPos, IBlockState> getHarvestPositions(World world, BlockPos pos) {
        IBlockState state;
        TreeMap<BlockPos, IBlockState> ret = new TreeMap<BlockPos, IBlockState>(Collections.reverseOrder());
        BlockPos currentPos = pos.func_177984_a();
        while (currentPos.func_177956_o() < pos.func_177956_o() + 10 && this.stateMatcher.test(state = world.func_180495_p(currentPos))) {
            ret.put(currentPos, state);
            currentPos = currentPos.func_177984_a();
        }
        return ret;
    }

    @Override
    public List<BlockPos> getPositionsToHarvest(World world, BlockPos pos, IBlockState state) {
        if (this.stateMatcher.test(world.func_180495_p(pos.func_177984_a()))) {
            return Collections.singletonList(pos);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canBeFertilized(IBlockState state, World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean matches(IBlockState state) {
        return this.stateMatcher.test(state);
    }
}

