/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public final class WorkSiteQuarry
extends TileWorksiteBoundedInventory {
    private boolean finished;
    private boolean hasDoneInit = false;
    private BlockPos current = BlockPos.field_177992_a;
    private BlockPos validate = BlockPos.field_177992_a;
    private static final IWorksiteAction DIG_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    protected void onBoundsSet() {
        super.onBoundsSet();
        this.offsetBounds();
    }

    private void offsetBounds() {
        BlockPos boundsMax = this.getWorkBoundsMax();
        this.setWorkBoundsMax(boundsMax.func_177981_b(this.field_174879_c.func_177956_o() - 1 - boundsMax.func_177956_o()));
        boundsMax = this.getWorkBoundsMin();
        this.setWorkBoundsMin(boundsMax.func_177981_b(1 - boundsMax.func_177956_o()));
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public void onBoundsAdjusted() {
        this.offsetBounds();
        this.validate = this.current = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.getWorkBoundsMax().func_177956_o(), this.getWorkBoundsMin().func_177952_p());
    }

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, new WorksiteUpgrade[]{WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.QUARRY_MEDIUM, WorksiteUpgrade.QUARRY_LARGE, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3, WorksiteUpgrade.QUARRY_CHUNK_LOADER});
    }

    @Override
    public int getBoundsMaxWidth() {
        if (this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_LARGE)) {
            return 64;
        }
        return this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_MEDIUM) ? 32 : 16;
    }

    @Override
    protected void updateWorksite() {
        if (!this.hasDoneInit) {
            this.initWorkSite();
            this.hasDoneInit = true;
        }
        this.field_145850_b.field_72984_F.func_76320_a("Incremental Scan");
        if (this.canHarvest(this.validate)) {
            this.current = this.validate;
            this.finished = false;
        } else {
            this.incrementValidationPosition();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        super.addUpgrade(upgrade);
        this.validate = this.current = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.getWorkBoundsMax().func_177956_o(), this.getWorkBoundsMin().func_177952_p());
        this.finished = false;
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        return !this.finished ? Optional.of(DIG_ACTION) : Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (!this.hasDoneInit) {
            this.initWorkSite();
            this.hasDoneInit = true;
        }
        while (!this.canHarvest(this.current)) {
            if (this.incrementPosition()) continue;
            this.finished = true;
            return false;
        }
        return this.harvestBlock(this.current);
    }

    private boolean harvestBlock(BlockPos current) {
        IBlockState state = this.field_145850_b.func_180495_p(current);
        Block block = state.func_177230_c();
        NonNullList stacks = NonNullList.func_191196_a();
        block.getDrops(stacks, (IBlockAccess)this.field_145850_b, current, state, this.getFortune());
        if (!InventoryTools.insertItems((IItemHandler)this.mainInventory, (List<ItemStack>)stacks, true).isEmpty()) {
            return false;
        }
        if (!BlockTools.breakBlockNoDrops(this.field_145850_b, current, state)) {
            return false;
        }
        InventoryTools.insertOrDropItems((IItemHandler)this.mainInventory, (List<ItemStack>)stacks, this.field_145850_b, current);
        return true;
    }

    private boolean incrementPosition() {
        if (this.finished) {
            return false;
        }
        this.current = this.current.func_177974_f();
        if (this.current.func_177958_n() > this.getWorkBoundsMax().func_177958_n()) {
            this.current = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.current.func_177956_o(), this.current.func_177952_p());
            this.current = this.current.func_177968_d();
            if (this.current.func_177952_p() > this.getWorkBoundsMax().func_177952_p()) {
                this.current = new BlockPos(this.current.func_177958_n(), this.current.func_177956_o(), this.getWorkBoundsMin().func_177952_p());
                this.current = this.current.func_177977_b();
                if (this.current.func_177956_o() <= 0) {
                    return false;
                }
            }
        }
        return true;
    }

    private void incrementValidationPosition() {
        this.validate = this.validate.func_177974_f();
        if (this.validate.func_177956_o() >= this.current.func_177956_o() && this.validate.func_177952_p() >= this.current.func_177952_p() && this.validate.func_177958_n() >= this.current.func_177958_n()) {
            this.validate = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.getWorkBoundsMax().func_177956_o(), this.getWorkBoundsMin().func_177952_p());
        } else if (this.validate.func_177958_n() > this.getWorkBoundsMax().func_177958_n()) {
            this.validate = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.validate.func_177956_o(), this.validate.func_177952_p());
            this.validate = this.validate.func_177968_d();
            if (this.validate.func_177952_p() > this.getWorkBoundsMax().func_177952_p()) {
                this.validate = new BlockPos(this.validate.func_177958_n(), this.validate.func_177956_o(), this.getWorkBoundsMin().func_177952_p());
                this.validate = this.validate.func_177977_b();
                if (this.validate.func_177956_o() <= 0) {
                    this.validate = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.getWorkBoundsMax().func_177956_o(), this.getWorkBoundsMin().func_177952_p());
                }
            }
        }
    }

    private boolean canHarvest(BlockPos harvestPos) {
        IBlockState state = this.field_145850_b.func_180495_p(harvestPos);
        Block block = state.func_177230_c();
        if (this.field_145850_b.func_175623_d(harvestPos) || state.func_185904_a().func_76224_d()) {
            return false;
        }
        int harvestLevel = block.getHarvestLevel(state);
        if (harvestLevel >= 2) {
            int toolLevel = 1;
            if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_3)) {
                toolLevel = Integer.MAX_VALUE;
            } else if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_2)) {
                toolLevel = 3;
            } else if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_1)) {
                toolLevel = 2;
            }
            if (toolLevel < harvestLevel) {
                return false;
            }
        }
        return state.func_185887_b(this.field_145850_b, harvestPos) >= 0.0f;
    }

    private void initWorkSite() {
        BlockPos boundsMin = this.getWorkBoundsMin();
        this.setWorkBoundsMin(boundsMin.func_177981_b(1 - boundsMin.func_177956_o()));
        this.validate = this.current = new BlockPos(this.getWorkBoundsMin().func_177958_n(), this.getWorkBoundsMax().func_177956_o(), this.getWorkBoundsMin().func_177952_p());
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.MINING;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.current = BlockPos.func_177969_a((long)tag.func_74763_f("current"));
        this.validate = BlockPos.func_177969_a((long)tag.func_74763_f("validate"));
        this.finished = tag.func_74767_n("finished");
        this.hasDoneInit = tag.func_74767_n("init");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74772_a("current", this.current.func_177986_g());
        tag.func_74772_a("validate", this.validate.func_177986_g());
        tag.func_74757_a("finished", this.finished);
        tag.func_74757_a("init", this.hasDoneInit);
        return tag;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 24, this.field_174879_c);
        }
        return true;
    }
}

