/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteFishFarm
extends TileWorksiteBoundedInventory {
    private static final int MAX_WATER = 1280;
    private boolean harvestFish = true;
    private boolean harvestInk = true;
    private int waterBlockCount = 0;
    private int waterRescanDelay = 0;
    private static final IWorksiteAction FISH_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        return this.waterBlockCount > 0 ? Optional.of(FISH_ACTION) : Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        float percentOfMax = (float)this.waterBlockCount / 1280.0f;
        float check = this.field_145850_b.field_73012_v.nextFloat();
        if (check <= percentOfMax) {
            boolean fish = this.harvestFish;
            boolean ink = this.harvestInk;
            if (fish && ink) {
                fish = this.field_145850_b.field_73012_v.nextBoolean();
                boolean bl = ink = !fish;
            }
            if (fish) {
                LootContext.Builder context = new LootContext.Builder((WorldServer)this.field_145850_b);
                context.func_186469_a((float)this.getFortune());
                List fishStacks = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_145850_b.field_73012_v, context.func_186471_a());
                if (!InventoryTools.canInventoryHold((IItemHandler)this.mainInventory, fishStacks)) {
                    return false;
                }
                for (ItemStack fishStack : fishStacks) {
                    InventoryTools.insertOrDropItem((IItemHandler)this.mainInventory, fishStack, this.field_145850_b, this.field_174879_c);
                }
                return true;
            }
            if (ink) {
                ItemStack inkItem = new ItemStack(Items.field_151100_aR, 1, 0);
                int fortune = this.getFortune();
                if (fortune > 0) {
                    inkItem.func_190917_f(this.field_145850_b.field_73012_v.nextInt(fortune + 1));
                }
                if (!InventoryTools.canInventoryHold((IItemHandler)this.mainInventory, inkItem)) {
                    return false;
                }
                InventoryTools.insertOrDropItem((IItemHandler)this.mainInventory, inkItem, this.field_145850_b, this.field_174879_c);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    protected void onBoundsSet() {
        super.onBoundsSet();
        BlockPos boundsMax = this.getWorkBoundsMax();
        this.setWorkBoundsMax(boundsMax.func_177981_b(this.field_174879_c.func_177956_o() - 1 - boundsMax.func_177956_o()));
        boundsMax = this.getWorkBoundsMin();
        this.setWorkBoundsMin(boundsMax.func_177981_b(this.field_174879_c.func_177956_o() - 5 - boundsMax.func_177956_o()));
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public void onBoundsAdjusted() {
        super.onBoundsAdjusted();
        BlockPos boundsMax = this.getWorkBoundsMax();
        this.setWorkBoundsMax(boundsMax.func_177981_b(this.field_174879_c.func_177956_o() - 1 - boundsMax.func_177956_o()));
        boundsMax = this.getWorkBoundsMin();
        this.setWorkBoundsMin(boundsMax.func_177981_b(this.field_174879_c.func_177956_o() - 5 - boundsMax.func_177956_o()));
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public int getBoundsMaxHeight() {
        return 4;
    }

    public boolean harvestFish() {
        return this.harvestFish;
    }

    public boolean harvestInk() {
        return this.harvestInk;
    }

    public void setHarvest(boolean fish, boolean ink) {
        if (this.harvestFish != fish || this.harvestInk != ink) {
            this.harvestFish = fish;
            this.harvestInk = ink;
            this.func_70296_d();
        }
    }

    private void countWater() {
        this.waterBlockCount = 0;
        BlockPos min = this.getWorkBoundsMin();
        BlockPos max = this.getWorkBoundsMax();
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                IBlockState state;
                for (int y = max.func_177956_o(); y >= min.func_177956_o() && (state = this.field_145850_b.func_180495_p(new BlockPos(x, y, z))).func_185904_a() == Material.field_151586_h; --y) {
                    ++this.waterBlockCount;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.harvestFish = tag.func_74767_n("fish");
        this.harvestInk = tag.func_74767_n("ink");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("fish", this.harvestFish);
        tag.func_74757_a("ink", this.harvestInk);
        return tag;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 29, this.field_174879_c);
        }
        return true;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 16, this.field_174879_c);
    }

    @Override
    protected void updateWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("WaterCount");
        if (this.waterRescanDelay-- <= 0) {
            this.countWater();
            this.waterRescanDelay = 200;
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }
}

