/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.entity.AWFakePlayer;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.ItemWrapper;

public class WorkSiteAnimalFarm
extends TileWorksiteBoundedInventory {
    private static final int FOOD_INVENTORY_SIZE = 3;
    private static final int TOOL_INVENTORY_SIZE = 3;
    private int workerRescanDelay;
    private boolean shouldCountResources = true;
    public int maxPigCount = 6;
    public int maxCowCount = 6;
    public int maxChickenCount = 6;
    public int maxSheepCount = 6;
    private int wheatCount;
    private int bucketCount;
    private int carrotCount;
    private int seedCount;
    private int shearsSlot = -1;
    private List<EntityPair> pigsToBreed = new ArrayList<EntityPair>();
    private List<EntityPair> chickensToBreed = new ArrayList<EntityPair>();
    private List<EntityPair> cowsToBreed = new ArrayList<EntityPair>();
    private int cowsToMilk;
    private List<EntityPair> sheepToBreed = new ArrayList<EntityPair>();
    private List<Integer> sheepToShear = new ArrayList<Integer>();
    private List<Integer> entitiesToCull = new ArrayList<Integer>();
    private static final ArrayList<ItemWrapper> ANIMAL_DROPS = ItemWrapper.buildList("Animal Farm drops", AWAutomationStatics.animal_farm_pickups);
    public final ItemStackHandler foodInventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            WorkSiteAnimalFarm.this.func_70296_d();
            WorkSiteAnimalFarm.this.shouldCountResources = true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return WorkSiteAnimalFarm.this.isFood(stack.func_77973_b()) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    public final ItemStackHandler toolInventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            WorkSiteAnimalFarm.this.func_70296_d();
            WorkSiteAnimalFarm.this.shouldCountResources = true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return WorkSiteAnimalFarm.this.isTool(stack.func_77973_b()) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private static final IWorksiteAction SHEAR_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction MILK_COW_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BREED_SHEEP_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BREED_COWS_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BREED_CHICKEN_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction BREED_PIGS_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;
    private static final IWorksiteAction CULL_ACTION = IWorkSite.WorksiteImplementation::getEnergyPerActivation;

    public WorkSiteAnimalFarm() {
        this.setSideInventory(BlockRotationHandler.RelativeSide.FRONT, (IItemHandler)this.foodInventory, BlockRotationHandler.RelativeSide.FRONT);
        this.setSideInventory(BlockRotationHandler.RelativeSide.BOTTOM, (IItemHandler)this.toolInventory, BlockRotationHandler.RelativeSide.TOP);
    }

    private boolean isFood(Item item) {
        return item == Items.field_151014_N || item == Items.field_151015_O || item == Items.field_151172_bF;
    }

    private boolean isTool(Item item) {
        return item == Items.field_151133_ar || item instanceof ItemShears;
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    private boolean canShearSheep() {
        return this.shearsSlot >= 0 && !this.sheepToShear.isEmpty();
    }

    private boolean canMilkCow() {
        return this.bucketCount > 0 && this.cowsToMilk > 0;
    }

    private boolean canBreedSheep() {
        return this.wheatCount > 1 && !this.sheepToBreed.isEmpty();
    }

    private boolean canBreedCows() {
        return this.wheatCount > 1 && !this.cowsToBreed.isEmpty();
    }

    private boolean canBreedChicken() {
        return this.seedCount > 1 && !this.chickensToBreed.isEmpty();
    }

    private boolean canBreedPigs() {
        return this.carrotCount > 1 && !this.pigsToBreed.isEmpty();
    }

    private boolean canCull() {
        return !this.entitiesToCull.isEmpty();
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        if (this.canShearSheep()) {
            return Optional.of(SHEAR_ACTION);
        }
        if (this.canMilkCow()) {
            return Optional.of(MILK_COW_ACTION);
        }
        if (this.canBreedSheep()) {
            return Optional.of(BREED_SHEEP_ACTION);
        }
        if (this.canBreedCows()) {
            return Optional.of(BREED_COWS_ACTION);
        }
        if (this.canBreedChicken()) {
            return Optional.of(BREED_CHICKEN_ACTION);
        }
        if (this.canBreedPigs()) {
            return Optional.of(BREED_PIGS_ACTION);
        }
        if (this.canCull()) {
            return Optional.of(CULL_ACTION);
        }
        return Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        if (action == SHEAR_ACTION) {
            return this.tryShearing();
        }
        if (action == MILK_COW_ACTION) {
            if (this.tryMilking()) {
                InventoryTools.removeItems((IItemHandler)this.toolInventory, new ItemStack(Items.field_151133_ar), 1);
                InventoryTools.insertOrDropItem((IItemHandler)this.mainInventory, new ItemStack(Items.field_151117_aB), this.field_145850_b, this.field_174879_c);
                return true;
            }
        } else if (action == BREED_SHEEP_ACTION) {
            if (this.tryBreeding(this.sheepToBreed)) {
                this.wheatCount -= 2;
                InventoryTools.removeItems((IItemHandler)this.foodInventory, new ItemStack(Items.field_151015_O), 2);
                return true;
            }
        } else if (action == BREED_COWS_ACTION) {
            if (this.tryBreeding(this.cowsToBreed)) {
                this.wheatCount -= 2;
                InventoryTools.removeItems((IItemHandler)this.foodInventory, new ItemStack(Items.field_151015_O), 2);
                return true;
            }
        } else if (action == BREED_CHICKEN_ACTION) {
            if (this.tryBreeding(this.chickensToBreed)) {
                this.seedCount -= 2;
                InventoryTools.removeItems((IItemHandler)this.foodInventory, new ItemStack(Items.field_151014_N), 2);
                return true;
            }
        } else if (action == BREED_PIGS_ACTION) {
            if (this.tryBreeding(this.pigsToBreed)) {
                this.carrotCount -= 2;
                InventoryTools.removeItems((IItemHandler)this.foodInventory, new ItemStack(Items.field_151172_bF), 2);
                return true;
            }
        } else if (action == CULL_ACTION) {
            return this.tryCulling();
        }
        return false;
    }

    @Override
    protected void updateWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("Count Resources");
        if (this.shouldCountResources) {
            this.countResources();
            this.shouldCountResources = false;
        }
        this.field_145850_b.field_72984_F.func_76318_c("Animal Rescan");
        if (this.workerRescanDelay-- <= 0) {
            this.rescan();
            this.workerRescanDelay = 200;
        }
        this.field_145850_b.field_72984_F.func_76318_c("ItemPickup");
        if (this.field_145850_b.func_72820_D() % 128L == 0L) {
            this.pickupDrops();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    @Override
    public void onBlockBroken() {
        super.onBlockBroken();
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.foodInventory, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.toolInventory, this.field_174879_c);
    }

    private void countResources() {
        this.carrotCount = InventoryTools.getCountOf((IItemHandler)this.foodInventory, s -> s.func_77973_b() == Items.field_151172_bF);
        this.seedCount = InventoryTools.getCountOf((IItemHandler)this.foodInventory, s -> s.func_77973_b() == Items.field_151014_N);
        this.wheatCount = InventoryTools.getCountOf((IItemHandler)this.foodInventory, s -> s.func_77973_b() == Items.field_151015_O);
        this.bucketCount = InventoryTools.getCountOf((IItemHandler)this.toolInventory, s -> s.func_77973_b() == Items.field_151133_ar);
        this.shearsSlot = InventoryTools.findItemSlot((IItemHandler)this.toolInventory, s -> s.func_77973_b() instanceof ItemShears);
    }

    private void rescan() {
        this.pigsToBreed.clear();
        this.cowsToBreed.clear();
        this.cowsToMilk = 0;
        this.sheepToBreed.clear();
        this.chickensToBreed.clear();
        this.entitiesToCull.clear();
        List<EntityAnimal> entityList = EntityTools.getEntitiesWithinBounds(this.field_145850_b, EntityAnimal.class, this.getWorkBoundsMin(), this.getWorkBoundsMax());
        ArrayList<EntityAnimal> cows = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> pigs = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> sheep = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> chickens = new ArrayList<EntityAnimal>();
        for (EntityAnimal animal : entityList) {
            if (animal instanceof EntityCow) {
                cows.add(animal);
                continue;
            }
            if (animal instanceof EntityChicken) {
                chickens.add(animal);
                continue;
            }
            if (animal instanceof EntitySheep) {
                sheep.add(animal);
                continue;
            }
            if (!(animal instanceof EntityPig)) continue;
            pigs.add(animal);
        }
        this.scanForCows(cows);
        this.scanForSheep(sheep);
        this.scanForAnimals(chickens, this.chickensToBreed, this.maxChickenCount);
        this.scanForAnimals(pigs, this.pigsToBreed, this.maxPigCount);
    }

    private void scanForAnimals(List<EntityAnimal> animals, List<EntityPair> targets, int maxCount) {
        block0: for (int i = 0; i < animals.size(); ++i) {
            EntityAnimal animal1 = animals.get(i);
            int age = animal1.func_70874_b();
            if (age != 0 || animal1.func_70880_s()) continue;
            while (i + 1 < animals.size()) {
                EntityAnimal animal2;
                if ((age = (animal2 = animals.get(++i)).func_70874_b()) != 0 || animal2.func_70880_s()) continue;
                EntityPair breedingPair = new EntityPair((Entity)animal1, (Entity)animal2);
                targets.add(breedingPair);
                continue block0;
            }
        }
        int grownCount = 0;
        for (EntityAnimal animal : animals) {
            if (animal.func_70874_b() < 0) continue;
            ++grownCount;
        }
        if (grownCount > maxCount) {
            int cullCount = grownCount - maxCount;
            for (int i = 0; i < animals.size() && cullCount > 0; ++i) {
                if (animals.get(i).func_70874_b() < 0) continue;
                this.entitiesToCull.add(animals.get(i).func_145782_y());
                --cullCount;
            }
        }
    }

    private void scanForSheep(List<EntityAnimal> sheep) {
        this.scanForAnimals(sheep, this.sheepToBreed, this.maxSheepCount);
        for (EntityAnimal animal : sheep) {
            EntitySheep sheep1;
            if (animal.func_70874_b() < 0 || (sheep1 = (EntitySheep)animal).func_70892_o()) continue;
            this.sheepToShear.add(sheep1.func_145782_y());
        }
    }

    private void scanForCows(List<EntityAnimal> animals) {
        this.scanForAnimals(animals, this.cowsToBreed, this.maxCowCount);
        for (EntityAnimal animal : animals) {
            if (animal.func_70874_b() < 0) continue;
            ++this.cowsToMilk;
        }
    }

    private boolean tryBreeding(List<EntityPair> targets) {
        if (!targets.isEmpty()) {
            EntityPair pair = targets.remove(0);
            Entity animalA = pair.getEntityA(this.field_145850_b);
            Entity animalB = pair.getEntityB(this.field_145850_b);
            if (!(animalA instanceof EntityAnimal) || !(animalB instanceof EntityAnimal)) {
                return false;
            }
            if (animalA.func_70089_S() && animalB.func_70089_S()) {
                AWFakePlayer fakePlayer = AWFakePlayer.get(this.field_145850_b);
                ((EntityAnimal)animalA).func_146082_f((EntityPlayer)fakePlayer);
                ((EntityAnimal)animalB).func_146082_f((EntityPlayer)fakePlayer);
                return true;
            }
        }
        return false;
    }

    private boolean tryMilking() {
        return this.cowsToMilk > 0 && this.field_145850_b.field_73012_v.nextInt(this.cowsToMilk * 4) > this.cowsToMilk * 3;
    }

    private boolean tryShearing() {
        if (this.shearsSlot < 0 || this.sheepToShear.isEmpty()) {
            return false;
        }
        EntitySheep sheep = (EntitySheep)this.field_145850_b.func_73045_a(this.sheepToShear.remove(0).intValue());
        ItemStack shears = this.toolInventory.getStackInSlot(this.shearsSlot);
        if (sheep == null || !sheep.isShearable(shears, (IBlockAccess)this.field_145850_b, this.field_174879_c)) {
            return false;
        }
        NonNullList<ItemStack> items = InventoryTools.toNonNullList(sheep.onSheared(shears, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.getFortune()));
        for (ItemStack item : items) {
            InventoryTools.insertOrDropItem((IItemHandler)this.mainInventory, item, this.field_145850_b, this.field_174879_c);
        }
        return true;
    }

    private boolean tryCulling() {
        int fortune = this.getFortune();
        while (this.canCull()) {
            EntityAnimal animal;
            Entity entity = this.field_145850_b.func_73045_a(this.entitiesToCull.remove(0).intValue());
            if (!(entity instanceof EntityAnimal) || !entity.func_70089_S() || (animal = (EntityAnimal)entity).func_70880_s() || animal.func_70874_b() < 0) continue;
            animal.captureDrops = true;
            animal.field_70720_be = 10;
            animal.func_70097_a(DamageSource.field_76377_j, animal.func_110143_aJ() + 1.0f);
            for (EntityItem item : animal.capturedDrops) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_190926_b()) continue;
                if (fortune > 0) {
                    stack.func_190917_f(this.field_145850_b.field_73012_v.nextInt(fortune));
                }
                InventoryTools.insertOrDropItem((IItemHandler)this.mainInventory, stack, this.field_145850_b, this.field_174879_c);
            }
            animal.capturedDrops.clear();
            animal.captureDrops = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 26, this.field_174879_c);
        }
        return true;
    }

    private void pickupDrops() {
        List<EntityItem> items = EntityTools.getEntitiesWithinBounds(this.field_145850_b, EntityItem.class, this.getWorkBoundsMin(), this.getWorkBoundsMax());
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (!item.func_70089_S() || stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) continue;
            Item droppedItem = stack.func_77973_b();
            for (ItemWrapper animalDrop : ANIMAL_DROPS) {
                if ((!droppedItem.equals(animalDrop.item) || animalDrop.damage != -1) && animalDrop.damage != stack.func_77952_i()) continue;
                if (!(stack = InventoryTools.mergeItemStack((IItemHandler)this.mainInventory, stack)).func_190926_b()) {
                    item.func_92058_a(stack);
                    continue;
                }
                item.func_70106_y();
            }
        }
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 14, this.field_174879_c);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.maxChickenCount = tag.func_74762_e("maxChickens");
        this.maxCowCount = tag.func_74762_e("maxCows");
        this.maxPigCount = tag.func_74762_e("maxPigs");
        this.maxSheepCount = tag.func_74762_e("maxSheep");
        this.foodInventory.deserializeNBT(tag.func_74775_l("foodInventory"));
        this.toolInventory.deserializeNBT(tag.func_74775_l("toolInventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("maxChickens", this.maxChickenCount);
        tag.func_74768_a("maxCows", this.maxCowCount);
        tag.func_74768_a("maxPigs", this.maxPigCount);
        tag.func_74768_a("maxSheep", this.maxSheepCount);
        tag.func_74782_a("foodInventory", (NBTBase)this.foodInventory.serializeNBT());
        tag.func_74782_a("toolInventory", (NBTBase)this.toolInventory.serializeNBT());
        return tag;
    }

    private static class EntityPair {
        private final int idA;
        private final int idB;

        private EntityPair(Entity a, Entity b) {
            this.idA = a.func_145782_y();
            this.idB = b.func_145782_y();
        }

        private Entity getEntityA(World world) {
            return world.func_73045_a(this.idA);
        }

        private Entity getEntityB(World world) {
            return world.func_73045_a(this.idB);
        }
    }
}

