/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.item.ItemWorksiteUpgrade;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import org.apache.commons.lang3.math.NumberUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux", striprefs=true), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux", striprefs=true)})
public abstract class TileWorksiteBase
extends TileUpdatable
implements ITickable,
IWorkSite,
IInteractableTile,
IOwnable,
BlockRotationHandler.IRotatableTile,
IEnergyProvider,
IEnergyReceiver {
    private static final String UPGRADES_TAG = "upgrades";
    private static final String ORIENTATION_TAG = "orientation";
    private static final String ACTIVE_TAG = "active";
    private Owner owner = Owner.EMPTY;
    private double efficiencyBonusFactor = 0.0;
    private EnumSet<WorksiteUpgrade> upgrades = EnumSet.noneOf(WorksiteUpgrade.class);
    private EnumFacing orientation = EnumFacing.NORTH;
    private final ITorque.TorqueCell torqueCell = new ITorque.TorqueCell(32.0, 0.0, AWCoreStatics.energyPerWorkUnit * 3.0, 1.0);
    private int workRetryDelay = 20;
    private boolean active = false;
    private int timeSinceLastActiveCheck = 0;

    @Optional.Method(modid="redstoneflux")
    public final int getEnergyStored(EnumFacing from) {
        return (int)(this.getTorqueStored(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="redstoneflux")
    public final int getMaxEnergyStored(EnumFacing from) {
        return (int)(this.getMaxTorque(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="redstoneflux")
    public final boolean canConnectEnergy(EnumFacing from) {
        return this.canOutputTorque(from) || this.canInputTorque(from);
    }

    @Optional.Method(modid="redstoneflux")
    public final int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.canInputTorque(from)) {
            return 0;
        }
        if (simulate) {
            return Math.min(maxReceive, (int)(AWAutomationStatics.torqueToRf * this.getMaxTorqueInput(from)));
        }
        return (int)(AWAutomationStatics.torqueToRf * this.addTorque(from, (double)maxReceive * AWAutomationStatics.rfToTorque));
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public final Set<WorksiteUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3);
    }

    @Override
    public void onBlockBroken() {
        for (WorksiteUpgrade ug : this.upgrades) {
            InventoryTools.dropItemInWorld(this.field_145850_b, ItemWorksiteUpgrade.getStack(ug), this.field_174879_c);
        }
        this.efficiencyBonusFactor = 0.0;
        this.upgrades.clear();
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        this.upgrades.add(upgrade);
        this.updateEfficiency();
        BlockTools.notifyBlockUpdate(this);
        this.func_70296_d();
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
        this.upgrades.remove((Object)upgrade);
        this.updateEfficiency();
        BlockTools.notifyBlockUpdate(this);
        this.func_70296_d();
    }

    public int getFortune() {
        if (this.getUpgrades().contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_2)) {
            return 2;
        }
        return this.getUpgrades().contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_1) ? 1 : 0;
    }

    protected abstract Optional<IWorksiteAction> getNextAction();

    protected abstract boolean processAction(IWorksiteAction var1);

    protected abstract void updateWorksite();

    public final void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K || this.field_145850_b.func_175676_y(this.field_174879_c) != 0) {
            return;
        }
        if (this.workRetryDelay > 0) {
            --this.workRetryDelay;
        } else {
            boolean hasWork;
            this.field_145850_b.field_72984_F.func_76320_a("Check For Work");
            Optional<IWorksiteAction> nextAction = this.getNextAction();
            boolean bl = hasWork = nextAction.isPresent() && nextAction.get().getEnergyConsumed(this.efficiencyBonusFactor) <= this.getTorqueStored(null);
            if (this.timeSinceLastActiveCheck < 0) {
                if (this.active != this.checkIfActive()) {
                    this.active = this.checkIfActive();
                    BlockTools.notifyBlockUpdate(this);
                }
                this.timeSinceLastActiveCheck = 60;
            } else {
                --this.timeSinceLastActiveCheck;
            }
            if (hasWork) {
                this.field_145850_b.field_72984_F.func_76318_c("Process Work");
                IWorksiteAction action = nextAction.get();
                if (this.processAction(action)) {
                    this.torqueCell.setEnergy(this.torqueCell.getEnergy() - action.getEnergyConsumed(this.efficiencyBonusFactor));
                    this.func_70296_d();
                } else {
                    this.workRetryDelay = 20;
                }
            }
            this.field_145850_b.field_72984_F.func_76319_b();
        }
        this.field_145850_b.field_72984_F.func_76320_a("WorksiteBaseUpdate");
        this.updateWorksite();
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private boolean checkIfActive() {
        return this.getTorqueStored(null) > 0.0;
    }

    private void updateEfficiency() {
        this.efficiencyBonusFactor = IWorkSite.WorksiteImplementation.getEfficiencyFactor(this.upgrades);
    }

    @Override
    public final Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.owner.getName());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public final boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public final void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public final void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public final float getClientOutputRotation(EnumFacing from, float delta) {
        return 0.0f;
    }

    @Override
    public final boolean useOutputRotation(@Nullable EnumFacing from) {
        return false;
    }

    @Override
    public final double getMaxTorqueOutput(EnumFacing from) {
        return 0.0;
    }

    @Override
    public final boolean canOutputTorque(EnumFacing towards) {
        return false;
    }

    @Override
    public final double drainTorque(EnumFacing from, double energy) {
        return 0.0;
    }

    @Override
    public final void addEnergyFromWorker(IWorker worker) {
        this.addTorque(null, AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType()) * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public final void addEnergyFromPlayer(EntityPlayer player) {
        this.addTorque(null, AWCoreStatics.energyPerWorkUnit * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public final double addTorque(@Nullable EnumFacing from, double energy) {
        return this.torqueCell.addEnergy(energy);
    }

    @Override
    public final double getMaxTorque(@Nullable EnumFacing from) {
        return this.torqueCell.getMaxEnergy();
    }

    @Override
    public final double getTorqueStored(@Nullable EnumFacing from) {
        return this.torqueCell.getEnergy();
    }

    @Override
    public final double getMaxTorqueInput(@Nullable EnumFacing from) {
        return this.torqueCell.getMaxTickInput();
    }

    @Override
    public final boolean canInputTorque(EnumFacing from) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public String toString() {
        return "Worksite Base[" + this.torqueCell.getEnergy() + "]";
    }

    @Override
    public boolean hasWork() {
        return this.torqueCell.getEnergy() < this.torqueCell.getMaxEnergy() && this.field_145850_b.func_175676_y(this.field_174879_c) == 0;
    }

    @Override
    public final EnumFacing getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public final void setPrimaryFacing(EnumFacing face) {
        this.orientation = face;
        BlockTools.notifyBlockUpdate(this);
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("storedEnergy", this.torqueCell.getEnergy());
        this.owner.serializeToNBT(tag);
        if (!this.getUpgrades().isEmpty()) {
            int[] ug = new int[this.getUpgrades().size()];
            int i = 0;
            for (WorksiteUpgrade u : this.getUpgrades()) {
                ug[i] = u.ordinal();
                ++i;
            }
            tag.func_74783_a(UPGRADES_TAG, ug);
        }
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.torqueCell.setEnergy(tag.func_74769_h("storedEnergy"));
        this.owner = Owner.deserializeFromNBT(tag);
        if (tag.func_74764_b(UPGRADES_TAG)) {
            NBTBase upgradeTag = tag.func_74781_a(UPGRADES_TAG);
            if (upgradeTag instanceof NBTTagIntArray) {
                int[] ug;
                for (int anUg : ug = tag.func_74759_k(UPGRADES_TAG)) {
                    this.upgrades.add(WorksiteUpgrade.values()[anUg]);
                }
            } else if (upgradeTag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)upgradeTag;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    String st = list.func_150307_f(i);
                    int ug = NumberUtils.toInt((String)st, (int)-1);
                    if (ug <= -1) continue;
                    this.upgrades.add(WorksiteUpgrade.values()[ug]);
                }
            }
        }
        if (tag.func_74764_b(ORIENTATION_TAG)) {
            this.orientation = EnumFacing.values()[tag.func_74762_e(ORIENTATION_TAG)];
        }
        this.updateEfficiency();
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        int[] ugs = new int[this.upgrades.size()];
        int i = 0;
        for (WorksiteUpgrade ug : this.upgrades) {
            ugs[i] = ug.ordinal();
            ++i;
        }
        tag.func_74783_a(UPGRADES_TAG, ugs);
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
        tag.func_74757_a(ACTIVE_TAG, this.active);
        this.owner.serializeToNBT(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.upgrades.clear();
        if (tag.func_74764_b(UPGRADES_TAG)) {
            int[] ugs;
            for (int ug : ugs = tag.func_74759_k(UPGRADES_TAG)) {
                this.upgrades.add(WorksiteUpgrade.values()[ug]);
            }
        }
        this.updateEfficiency();
        this.orientation = EnumFacing.values()[tag.func_74762_e(ORIENTATION_TAG)];
        this.active = tag.func_74767_n(ACTIVE_TAG);
        this.owner = Owner.deserializeFromNBT(tag);
        BlockTools.notifyBlockUpdate(this);
    }
}

