/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public final class WarehouseInterfaceFilter
implements Predicate<ItemStack>,
INBTSerializable<NBTTagCompound> {
    @Nonnull
    private ItemStack filterItem = ItemStack.field_190927_a;
    private int quantity;

    public boolean apply(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        if (this.filterItem.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() != this.filterItem.func_77973_b()) {
            return false;
        }
        return InventoryTools.doItemStacksMatchRelaxed(this.filterItem, item);
    }

    public boolean equals(Object object) {
        return object instanceof WarehouseInterfaceFilter && ((WarehouseInterfaceFilter)object).quantity == this.quantity && ItemStack.func_77989_b((ItemStack)this.filterItem, (ItemStack)((WarehouseInterfaceFilter)object).filterItem);
    }

    public int hashCode() {
        int result = !this.getFilterItem().func_190926_b() ? new ItemQuantityMap.ItemHashEntry(this.getFilterItem()).hashCode() : 0;
        return 31 * result + this.quantity;
    }

    public final ItemStack getFilterItem() {
        return this.filterItem;
    }

    public final void setFilterItem(ItemStack item) {
        this.filterItem = item;
    }

    public final int getFilterQuantity() {
        return this.quantity;
    }

    public final void setFilterQuantity(int filterQuantity) {
        this.quantity = filterQuantity;
    }

    public String toString() {
        return "Filter item: " + this.filterItem + " quantity: " + this.quantity;
    }

    public WarehouseInterfaceFilter copy() {
        WarehouseInterfaceFilter filter = new WarehouseInterfaceFilter();
        if (!this.filterItem.func_190926_b()) {
            filter.setFilterItem(this.filterItem.func_77946_l());
        }
        filter.setFilterQuantity(this.quantity);
        return filter;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("quantity", this.quantity);
        if (!this.filterItem.func_190926_b()) {
            tag.func_74782_a("filter", (NBTBase)this.filterItem.func_77955_b(new NBTTagCompound()));
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.quantity = tag.func_74762_e("quantity");
        if (tag.func_74764_b("filter")) {
            this.filterItem = new ItemStack(tag.func_74775_l("filter"));
        }
    }
}

