/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque.multiblock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.init.AWAutomationBlocks;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockFinder;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import org.apache.commons.lang3.tuple.Pair;

public class TileWindmillBlade
extends TileUpdatable
implements ITickable {
    private static final String IS_CONTROL_TAG = "isControl";
    private static final String CONTROL_POS_TAG = "controlPos";
    private static final String DIRECTION_TAG = "direction";
    private double bladeRpm = 20.0;
    private double bladeRpt = this.bladeRpm * (double)0.3f;
    private BlockPos controlPos;
    private boolean isControl = false;
    protected float rotation;
    private float lastRotationDiff;
    private int windmillSize = 0;
    public double energy = 0.0;
    private EnumFacing windmillDirection = EnumFacing.NORTH;

    public boolean isControl() {
        return this.isControl;
    }

    public boolean isFormed() {
        return this.controlPos != null;
    }

    public EnumFacing getDirection() {
        return this.windmillDirection;
    }

    public int getWindmillSize() {
        return this.windmillSize;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void func_73660_a() {
        if (this.isControl) {
            if (!this.field_145850_b.field_72995_K) {
                this.energy = (double)this.windmillSize * AWAutomationStatics.windmill_per_size_output;
            } else {
                this.updateRotation();
            }
        }
    }

    public float getRotation(float delta) {
        return this.rotation - this.lastRotationDiff * (1.0f - delta);
    }

    private void updateRotation() {
        this.lastRotationDiff = (float)(this.bladeRpt * 0.01745329238474369);
        this.rotation += this.lastRotationDiff;
        this.rotation %= (float)Math.PI * 2;
    }

    public void blockPlaced() {
        if (!this.field_145850_b.field_72995_K) {
            this.validateSetup();
        }
    }

    public void blockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isControl) {
                int expand = (this.windmillSize - 1) / 2;
                if (expand > 0) {
                    if (this.windmillDirection.func_176740_k() == EnumFacing.Axis.Z) {
                        for (int j = -expand; j < expand + 1; ++j) {
                            for (int i = -expand; i < expand + 1; ++i) {
                                WorldTools.getTile((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177982_a(i, j, 0), TileWindmillBlade.class).ifPresent(t -> t.setController(null));
                            }
                        }
                    } else if (this.windmillDirection.func_176740_k() == EnumFacing.Axis.X) {
                        for (int j = -expand; j < expand + 1; ++j) {
                            for (int i = -expand; i < expand + 1; ++i) {
                                WorldTools.getTile((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177982_a(0, j, i), TileWindmillBlade.class).ifPresent(t -> t.setController(null));
                            }
                        }
                    }
                }
                this.isControl = false;
            } else if (this.controlPos != null) {
                WorldTools.getTile((IBlockAccess)this.field_145850_b, this.controlPos, TileWindmillBlade.class).ifPresent(TileWindmillBlade::validateSetup);
                this.controlPos = null;
            } else {
                this.informNeighborsToValidate();
            }
        }
    }

    private boolean validateSetup() {
        boolean valid;
        BlockFinder finder = new BlockFinder(this.field_145850_b, this.func_145838_q(), this.func_145832_p(), 81);
        Pair<BlockPos, BlockPos> corners = finder.cross(this.field_174879_c);
        int minX = ((BlockPos)corners.getLeft()).func_177958_n();
        int minY = ((BlockPos)corners.getLeft()).func_177956_o();
        int minZ = ((BlockPos)corners.getLeft()).func_177952_p();
        int xSize = ((BlockPos)corners.getRight()).func_177958_n() - minX + 1;
        int ySize = ((BlockPos)corners.getRight()).func_177956_o() - minY + 1;
        int zSize = ((BlockPos)corners.getRight()).func_177952_p() - minZ + 1;
        boolean bl = valid = !(ySize < 5 || ySize % 2 != 1 || zSize != 1 && xSize != 1 || zSize != ySize && xSize != ySize || !finder.box(corners));
        if (valid) {
            int controlZ;
            int controlX;
            int halfSize = (ySize - 1) / 2;
            int controlY = minY + halfSize;
            if (xSize > 1) {
                controlX = minX + halfSize;
                controlZ = minZ;
            } else {
                controlX = minX;
                controlZ = minZ + halfSize;
            }
            this.setValidSetup(finder.getPositions(), controlX, controlY, controlZ, xSize, ySize, zSize);
        } else {
            finder.connect((BlockPos)corners.getLeft(), new BlockPos(xSize, ySize, zSize));
            this.setInvalidSetup(this.getAllConnectedBlades());
        }
        return valid;
    }

    private List<BlockPos> getAllConnectedBlades() {
        int maxRadius = 20;
        ArrayList connectedBlocks = Lists.newArrayList();
        ArrayList searchedPositions = Lists.newArrayList();
        BlockPos currentPos = this.field_174879_c;
        connectedBlocks.add(currentPos);
        searchedPositions.add(currentPos);
        this.getConnectedBlades(maxRadius, connectedBlocks, searchedPositions, currentPos);
        return connectedBlocks;
    }

    private void getConnectedBlades(int maxRadius, List<BlockPos> connectedBlocks, List<BlockPos> searchedPositions, BlockPos currentPos) {
        if (currentPos.func_185332_f(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()) < (double)maxRadius) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = currentPos.func_177972_a(facing);
                if (searchedPositions.contains(offsetPos) || this.field_145850_b.func_180495_p(offsetPos).func_177230_c() != AWAutomationBlocks.WINDMILL_BLADE) continue;
                connectedBlocks.add(offsetPos);
                searchedPositions.add(offsetPos);
                this.getConnectedBlades(maxRadius, connectedBlocks, searchedPositions, offsetPos);
            }
        }
    }

    private void informNeighborsToValidate() {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            WorldTools.getTile((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(d), TileWindmillBlade.class).ifPresent(TileWindmillBlade::validateSetup);
        }
    }

    private void setController(@Nullable BlockPos pos) {
        boolean dirty = false;
        if (pos == null) {
            if (this.isControl || this.controlPos != null) {
                dirty = true;
            }
            this.isControl = false;
            this.controlPos = null;
        } else {
            if (!pos.equals((Object)this.controlPos)) {
                dirty = true;
            }
            this.controlPos = pos;
        }
        if (dirty) {
            this.func_70296_d();
            BlockTools.notifyBlockUpdate(this);
        }
    }

    private void setInvalidSetup(List<BlockPos> set) {
        for (BlockPos pos : set) {
            WorldTools.getTile((IBlockAccess)this.field_145850_b, pos, TileWindmillBlade.class).ifPresent(t -> t.setController(null));
        }
    }

    private void setValidSetup(List<BlockPos> set, int cx, int cy, int cz, int xs, int ys, int zs) {
        this.setController(new BlockPos(cx, cy, cz));
        Optional<TileWindmillBlade> te = WorldTools.getTile((IBlockAccess)this.field_145850_b, this.controlPos, TileWindmillBlade.class);
        if (te.isPresent()) {
            te.get().setAsController(xs, ys, zs);
            for (BlockPos pos : set) {
                WorldTools.getTile((IBlockAccess)this.field_145850_b, pos, TileWindmillBlade.class).ifPresent(t -> t.setController(this.controlPos));
            }
        } else {
            this.setController(null);
        }
    }

    private void setAsController(int xSize, int ySize, int zSize) {
        this.windmillDirection = xSize == 1 ? EnumFacing.WEST : EnumFacing.NORTH;
        this.windmillSize = ySize;
        this.isControl = true;
        this.func_70296_d();
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74757_a(IS_CONTROL_TAG, this.isControl);
        if (this.controlPos != null) {
            tag.func_74772_a(CONTROL_POS_TAG, this.controlPos.func_177986_g());
        }
        if (this.isControl) {
            tag.func_74768_a("size", this.windmillSize);
            tag.func_74774_a(DIRECTION_TAG, (byte)this.windmillDirection.ordinal());
        }
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.controlPos = tag.func_74764_b(CONTROL_POS_TAG) ? BlockPos.func_177969_a((long)tag.func_74763_f(CONTROL_POS_TAG)) : null;
        this.isControl = tag.func_74767_n(IS_CONTROL_TAG);
        if (this.isControl) {
            this.windmillSize = tag.func_74762_e("size");
            this.windmillDirection = EnumFacing.field_82609_l[tag.func_74771_c(DIRECTION_TAG)];
        }
        BlockTools.notifyBlockUpdate(this);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.controlPos = tag.func_74764_b(CONTROL_POS_TAG) ? BlockPos.func_177969_a((long)tag.func_74763_f(CONTROL_POS_TAG)) : null;
        this.isControl = tag.func_74767_n(IS_CONTROL_TAG);
        if (this.isControl) {
            this.windmillSize = tag.func_74762_e("size");
            this.windmillDirection = EnumFacing.field_82609_l[tag.func_74771_c(DIRECTION_TAG)];
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a(IS_CONTROL_TAG, this.isControl);
        if (this.controlPos != null) {
            tag.func_74772_a(CONTROL_POS_TAG, this.controlPos.func_177986_g());
        }
        if (this.isControl) {
            tag.func_74768_a("size", this.windmillSize);
            tag.func_74774_a(DIRECTION_TAG, (byte)this.windmillDirection.ordinal());
        }
        return tag;
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isControl && super.shouldRenderInPass(pass);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int expand = (this.windmillSize - 1) / 2;
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - expand), (double)(this.field_174879_c.func_177956_o() - expand), (double)(this.field_174879_c.func_177952_p() - expand), (double)(this.field_174879_c.func_177958_n() + 1 + expand), (double)(this.field_174879_c.func_177956_o() + 1 + expand), (double)(this.field_174879_c.func_177952_p() + 1 + expand));
    }
}

