/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque.multiblock;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBlockEvent;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockFinder;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import org.apache.commons.lang3.tuple.Pair;

public class TileFlywheelStorage
extends TileUpdatable
implements ITickable {
    private static final String CONTROLLER_POS_TAG = "controllerPos";
    private static final String IS_CONTROL_TAG = "isControl";
    private static final String SET_WIDTH_TAG = "setWidth";
    private static final String SET_HEIGHT_TAG = "setHeight";
    public BlockPos controllerPos;
    public boolean isControl = false;
    public int setWidth;
    public int setHeight;
    private int setCube;
    public double storedEnergy;
    public double maxEnergyStored;
    private double maxRpm = 100.0;
    public double torqueLoss;
    public double rotation;
    public double lastRotationDiff;
    private int clientEnergy;
    private int clientDestEnergy;
    private int networkUpdateTicks = 0;

    public void func_73660_a() {
        if (this.isControl) {
            if (this.field_145850_b.field_72995_K) {
                this.clientNetworkUpdate();
            } else {
                this.serverNetworkUpdate();
                this.applyPowerLoss();
            }
        }
    }

    protected void clientNetworkUpdate() {
        this.updateRotation();
        if (this.networkUpdateTicks > 0) {
            int diff = this.clientDestEnergy - this.clientEnergy;
            this.clientEnergy += diff / this.networkUpdateTicks;
            --this.networkUpdateTicks;
        }
    }

    protected void applyPowerLoss() {
        double eff = 1.0 - this.getEfficiency();
        this.torqueLoss = this.storedEnergy * (eff *= 0.1);
        this.storedEnergy -= this.torqueLoss;
    }

    protected double getEfficiency() {
        int meta = this.func_145832_p();
        switch (meta) {
            case 0: {
                return AWAutomationStatics.low_efficiency_factor;
            }
            case 1: {
                return AWAutomationStatics.med_efficiency_factor;
            }
            case 2: {
                return AWAutomationStatics.high_efficiency_factor;
            }
        }
        return AWAutomationStatics.low_efficiency_factor;
    }

    private void serverNetworkUpdate() {
        if (!AWAutomationStatics.enable_energy_network_updates) {
            return;
        }
        --this.networkUpdateTicks;
        if (this.networkUpdateTicks <= 0) {
            double percentStored = this.storedEnergy / this.maxEnergyStored;
            int total = (int)(percentStored * 100.0);
            if (total != this.clientEnergy) {
                this.clientEnergy = total;
                this.sendDataToClient(1, this.clientEnergy);
            }
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
    }

    protected final void sendDataToClient(int type, int data) {
        PacketBlockEvent pkt = new PacketBlockEvent(this.field_174879_c, this.func_145838_q(), (byte)type, (short)data);
        NetworkHandler.sendToAllTrackingChunk(this.field_145850_b, this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4, pkt);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a == 1) {
            this.clientDestEnergy = b;
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
        return true;
    }

    private void updateRotation() {
        double rpm = (double)this.clientEnergy * 0.01 * this.maxRpm;
        this.lastRotationDiff = -(rpm * (double)0.3f) * 0.01745329238474369;
        this.rotation += this.lastRotationDiff;
        this.rotation %= 6.2831854820251465;
    }

    public void blockBroken() {
        this.informNeighborsToValidate();
    }

    public final void blockPlaced() {
        this.validateSetup();
    }

    private void setController(@Nullable BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        boolean bl = this.isControl = controllerPos == null || controllerPos.equals((Object)this.field_174879_c);
        if (controllerPos == null) {
            this.setWidth = 1;
            this.setHeight = 1;
            this.setCube = 1;
        }
        this.func_70296_d();
        BlockTools.notifyBlockUpdate(this);
    }

    private boolean validateSetup() {
        boolean valid;
        BlockFinder finder = new BlockFinder(this.field_145850_b, this.func_145838_q(), this.func_145832_p(), 30);
        Pair<BlockPos, BlockPos> corners = finder.cross(this.field_174879_c);
        int minX = ((BlockPos)corners.getLeft()).func_177958_n();
        int minY = ((BlockPos)corners.getLeft()).func_177956_o();
        int minZ = ((BlockPos)corners.getLeft()).func_177952_p();
        int w = ((BlockPos)corners.getRight()).func_177958_n() - minX + 1;
        int h = ((BlockPos)corners.getRight()).func_177956_o() - minY + 1;
        int l = ((BlockPos)corners.getRight()).func_177952_p() - minZ + 1;
        boolean bl = valid = w == l && (w == 1 || w == 3) && finder.box(corners);
        if (valid) {
            int cx = w == 1 ? minX : minX + 1;
            int cz = l == 1 ? minZ : minZ + 1;
            this.setValidSetup(finder.getPositions(), cx, minY, cz, w, h, this.func_145832_p());
        } else {
            this.setInvalidSetup(finder.getAllConnectedBlocks(this.field_174879_c));
        }
        return valid;
    }

    private void setValidSetup(List<BlockPos> set, int cx, int cy, int cz, int size, int height, int type) {
        this.controllerPos = new BlockPos(cx, cy, cz);
        Optional<TileFlywheelStorage> te = WorldTools.getTile((IBlockAccess)this.field_145850_b, this.controllerPos, TileFlywheelStorage.class);
        if (te.isPresent()) {
            te.get().setAsController(size, height, type);
            for (BlockPos pos : set) {
                WorldTools.getTile((IBlockAccess)this.field_145850_b, pos, TileFlywheelStorage.class).ifPresent(t -> t.setController(this.controllerPos));
            }
        } else {
            this.controllerPos = null;
        }
    }

    private void setAsController(int size, int height, int type) {
        this.isControl = true;
        this.setWidth = size;
        this.setHeight = height;
        this.setCube = size * size * height;
        double energyPerBlockForType = 1600.0;
        switch (type) {
            case 0: {
                energyPerBlockForType = AWAutomationStatics.low_storage_energy_max;
                break;
            }
            case 1: {
                energyPerBlockForType = AWAutomationStatics.med_storage_energy_max;
                break;
            }
            case 2: {
                energyPerBlockForType = AWAutomationStatics.high_storage_energy_max;
            }
        }
        this.maxEnergyStored = (double)this.setCube * energyPerBlockForType;
        this.func_70296_d();
        BlockTools.notifyBlockUpdate(this);
    }

    private void setInvalidSetup(List<BlockPos> set) {
        this.setController(null);
        for (BlockPos pos : set) {
            WorldTools.getTile((IBlockAccess)this.field_145850_b, pos, TileFlywheelStorage.class).ifPresent(t -> t.setController(null));
        }
    }

    private void informNeighborsToValidate() {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            WorldTools.getTile((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(d), TileFlywheelStorage.class).ifPresent(TileFlywheelStorage::validateSetup);
        }
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        if (this.controllerPos != null) {
            tag.func_74772_a(CONTROLLER_POS_TAG, this.controllerPos.func_177986_g());
        }
        if (this.isControl) {
            tag.func_74757_a(IS_CONTROL_TAG, true);
            tag.func_74768_a(SET_WIDTH_TAG, this.setWidth);
            tag.func_74768_a(SET_HEIGHT_TAG, this.setHeight);
            tag.func_74768_a("clientEnergy", this.clientEnergy);
        }
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.controllerPos = tag.func_74764_b(CONTROLLER_POS_TAG) ? BlockPos.func_177969_a((long)tag.func_74763_f(CONTROLLER_POS_TAG)) : null;
        this.isControl = tag.func_74767_n(IS_CONTROL_TAG);
        if (this.isControl) {
            this.setHeight = tag.func_74762_e(SET_HEIGHT_TAG);
            this.setWidth = tag.func_74762_e(SET_WIDTH_TAG);
            this.setCube = this.setWidth * this.setWidth * this.setHeight;
            this.clientEnergy = tag.func_74762_e("clientEnergy");
        }
        BlockTools.notifyBlockUpdate(this);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.controllerPos = tag.func_74764_b(CONTROLLER_POS_TAG) ? BlockPos.func_177969_a((long)tag.func_74763_f(CONTROLLER_POS_TAG)) : null;
        this.isControl = tag.func_74767_n(IS_CONTROL_TAG);
        if (this.isControl) {
            this.maxEnergyStored = tag.func_74769_h("maxEnergy");
            this.setHeight = tag.func_74762_e(SET_HEIGHT_TAG);
            this.setWidth = tag.func_74762_e(SET_WIDTH_TAG);
            this.setCube = this.setWidth * this.setWidth * this.setHeight;
        }
        this.storedEnergy = tag.func_74769_h("storedEnergy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.controllerPos != null) {
            tag.func_74772_a(CONTROLLER_POS_TAG, this.controllerPos.func_177986_g());
        }
        if (this.isControl) {
            tag.func_74757_a(IS_CONTROL_TAG, true);
            tag.func_74780_a("maxEnergy", this.maxEnergyStored);
            tag.func_74768_a(SET_WIDTH_TAG, this.setWidth);
            tag.func_74768_a(SET_HEIGHT_TAG, this.setHeight);
        }
        tag.func_74780_a("storedEnergy", this.storedEnergy);
        return tag;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)(this.field_174879_c.func_177956_o() - 1), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + this.setHeight), (double)(this.field_174879_c.func_177952_p() + 2));
    }
}

