/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public abstract class TileTorqueShaft
extends TileTorqueSingleCell {
    private TileTorqueShaft prev;
    private TileTorqueShaft next;
    private boolean prevNeighborInvalid = true;
    private boolean nextNeighborInvalid = true;

    public TileTorqueShaft() {
        double max = this.getMaxTransfer();
        this.torqueCell = new ITorque.TorqueCell(max, max, max, this.getEfficiency());
    }

    protected abstract double getEfficiency();

    protected abstract double getMaxTransfer();

    @Override
    protected void serverNetworkSynch() {
        if (this.prev() == null) {
            TileTorqueShaft last = this;
            TileTorqueShaft n = this.next();
            double totalPower = this.torqueCell.getEnergy();
            double num = 1.0;
            while (n != null) {
                totalPower += n.torqueCell.getEnergy();
                last = n;
                num += 1.0;
                n = n.next;
            }
            double avg = totalPower / num;
            double perc = avg / this.torqueCell.getMaxEnergy();
            double torqueOut = last.torqueOut;
            int percent = (int)(perc * 100.0);
            int percent2 = (int)(torqueOut / last.torqueCell.getMaxOutput() * 100.0);
            if ((percent = Math.max(percent, percent2)) != this.clientDestEnergyState) {
                this.clientDestEnergyState = percent;
                this.sendSideRotation(this.getPrimaryFacing(), percent);
            }
        }
    }

    @Override
    protected void updateRotation() {
        if (this.prev() == null) {
            if (this.clientEnergyState > 0.0) {
                this.lastRotationDiff = -(30.000001907348633 * this.clientEnergyState * 0.01) * 0.01745329238474369;
                this.rotation += this.lastRotationDiff;
                this.rotation %= 6.2831854820251465;
            }
            TileTorqueShaft n = this.next;
            while (n != null) {
                n.rotation = this.rotation;
                n.lastRotationDiff = this.lastRotationDiff;
                n = n.next;
            }
        }
    }

    @Override
    protected void onNeighborCacheInvalidated() {
        this.invalidateNeighborCache();
        this.invalidateLocalCache();
    }

    private void invalidateLocalCache() {
        this.prevNeighborInvalid = true;
        this.nextNeighborInvalid = true;
        this.next = null;
        this.prev = null;
    }

    private void invalidateNeighborCache() {
        if (this.next != null) {
            this.next.invalidateLocalCache();
        }
        if (this.prev != null) {
            this.prev.invalidateLocalCache();
        }
    }

    @Nullable
    public TileTorqueShaft prev() {
        if (this.prevNeighborInvalid) {
            this.prevNeighborInvalid = false;
            ITorque.ITorqueTile input = this.getTorqueCache()[this.orientation.func_176734_d().ordinal()];
            if (input instanceof TileTorqueShaft && input.getClass() == this.getClass() && input.canOutputTorque(this.orientation)) {
                if (this.prev == null) {
                    BlockTools.notifyBlockUpdate(this);
                }
                this.prev = (TileTorqueShaft)input;
                this.prev.next = this;
            }
        }
        return this.prev;
    }

    @Nullable
    public TileTorqueShaft next() {
        if (this.nextNeighborInvalid) {
            this.nextNeighborInvalid = false;
            ITorque.ITorqueTile output = this.getTorqueCache()[this.orientation.ordinal()];
            if (output instanceof TileTorqueShaft && output.getClass() == this.getClass() && output.canInputTorque(this.orientation.func_176734_d())) {
                this.next = (TileTorqueShaft)output;
                this.next.prev = this;
            }
        }
        return this.next;
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        return this.getRenderRotation(this.rotation, this.lastRotationDiff, delta);
    }
}

