/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileFlywheelController
extends TileTorqueSingleCell {
    private static final String POWERED_TAG = "powered";
    private boolean powered;
    private final ITorque.TorqueCell inputCell;

    public TileFlywheelController() {
        double max = this.getMaxTransfer();
        double eff = this.getEfficiency();
        this.inputCell = new ITorque.TorqueCell(max, max, max, eff);
        this.torqueCell = new ITorque.TorqueCell(max, max, max, eff);
    }

    protected abstract double getEfficiency();

    protected abstract double getMaxTransfer();

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueLoss += this.applyPowerDrain(this.inputCell);
            this.torqueLoss += this.applyDrainToStorage();
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.balancePower();
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    private double applyDrainToStorage() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        if (storage == null) {
            return 0.0;
        }
        return storage.torqueLoss;
    }

    private void balancePower() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        double in = this.inputCell.getEnergy();
        double out = this.torqueCell.getEnergy();
        double outputGap = this.torqueCell.getMaxEnergy() - out;
        double addOutput = Math.min(in, outputGap);
        in -= addOutput;
        out += addOutput;
        if (storage != null) {
            double store = storage.storedEnergy;
            double storeToTransfer = Math.min(store, this.torqueCell.getMaxEnergy() - out);
            out += storeToTransfer;
            double addToStore = Math.min(in, storage.maxEnergyStored - (store -= storeToTransfer));
            in -= addToStore;
            storage.storedEnergy = store += addToStore;
            this.torqueLoss += storage.torqueLoss;
        }
        this.torqueCell.setEnergy(out);
        this.inputCell.setEnergy(in);
    }

    @Override
    protected void updateRotation() {
        if (!this.powered) {
            super.updateRotation();
        }
    }

    @Nullable
    private TileFlywheelStorage getControlledFlywheel() {
        BlockPos controllerPos = this.field_174879_c.func_177972_a(EnumFacing.DOWN);
        return WorldTools.getTile((IBlockAccess)this.field_145850_b, controllerPos, TileFlywheelStorage.class).map(t -> {
            if (t.controllerPos != null) {
                BlockPos nextControllerPos = t.controllerPos;
                return WorldTools.getTile((IBlockAccess)this.field_145850_b, nextControllerPos, TileFlywheelStorage.class).orElse(null);
            }
            return null;
        }).orElse(null);
    }

    public float getFlywheelRotation(float delta) {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        return storage == null ? 0.0f : this.getRenderRotation(storage.rotation, storage.lastRotationDiff, delta);
    }

    private double getFlywheelEnergy() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        return storage == null ? 0.0 : storage.storedEnergy;
    }

    @Override
    protected double getTotalTorque() {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy() + this.getFlywheelEnergy();
    }

    @Override
    public void onNeighborTileChanged() {
        super.onNeighborTileChanged();
        if (!this.field_145850_b.field_72995_K) {
            boolean p;
            boolean bl = p = this.field_145850_b.func_175676_y(this.field_174879_c) > 0;
            if (p != this.powered) {
                this.powered = p;
                this.sendDataToClient(7, this.powered ? 1 : 0);
            }
        }
    }

    @Override
    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a == 7) {
            this.powered = b == 1;
        }
        return super.func_145842_c(a, b);
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        if (this.powered) {
            return 0.0;
        }
        return this.torqueCell.getMaxTickOutput();
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getEnergy();
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.addEnergy(energy);
    }

    @Override
    public double drainTorque(@Nullable EnumFacing from, double energy) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getMaxTickInput();
    }

    @Nullable
    private ITorque.TorqueCell getCell(@Nullable EnumFacing from) {
        if (from == this.orientation) {
            return this.torqueCell;
        }
        if (from == this.orientation.func_176734_d()) {
            return this.inputCell;
        }
        return null;
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.powered = tag.func_74767_n(POWERED_TAG);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74757_a(POWERED_TAG, this.powered);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a(POWERED_TAG, this.powered);
        tag.func_74780_a("torqueEnergyIn", this.inputCell.getEnergy());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powered = tag.func_74767_n(POWERED_TAG);
        this.inputCell.setEnergy(tag.func_74769_h("torqueEnergyIn"));
    }
}

